/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis.distance;

import java.io.IOException;
import marytts.signalproc.analysis.distance.BaselineLPSpectralEnvelopeDistortionComputer;
import marytts.signalproc.analysis.distance.SpectralDistanceMeasures;

public class ItakuraSaitoDistanceComputer
extends BaselineLPSpectralEnvelopeDistortionComputer {
    @Override
    public double frameDistance(double[] frm1, double[] frm2, int fftSize, int lpOrder) {
        super.frameDistance(frm1, frm2, fftSize, lpOrder);
        double dist = SpectralDistanceMeasures.itakuraSaitoDistSymmetric(frm1, frm2, fftSize, lpOrder);
        return dist;
    }

    public void mainParametricInterspeech2008(String outputFolder, String method, String emotion, String outputFilePostExtension) throws IOException {
        String tgtFolder = outputFolder + "target/" + emotion;
        String srcFolder = outputFolder + "source/" + emotion;
        String tfmFolder = outputFolder + method + "/" + emotion;
        String outputFile = outputFolder + method + "_" + emotion + "_" + outputFilePostExtension;
        String infoString = method + " " + emotion;
        this.mainParametric(srcFolder, tgtFolder, tfmFolder, outputFile, infoString);
    }

    public void mainInterspeech2008() throws IOException {
        String outputFolder = "D:/Oytun/DFKI/voices/Interspeech08_out/objective_test/";
        String outputFilePostExtension = "itakuraSaitoLPSpectralEnvelope.txt";
        String method = "1_codebook";
        String emotion = "angry";
        this.mainParametricInterspeech2008(outputFolder, method, emotion, outputFilePostExtension);
        emotion = "happy";
        this.mainParametricInterspeech2008(outputFolder, method, emotion, outputFilePostExtension);
        emotion = "sad";
        this.mainParametricInterspeech2008(outputFolder, method, emotion, outputFilePostExtension);
        emotion = "all";
        this.mainParametricInterspeech2008(outputFolder, method, emotion, outputFilePostExtension);
        method = "2_frame";
        emotion = "angry";
        this.mainParametricInterspeech2008(outputFolder, method, emotion, outputFilePostExtension);
        emotion = "happy";
        this.mainParametricInterspeech2008(outputFolder, method, emotion, outputFilePostExtension);
        emotion = "sad";
        this.mainParametricInterspeech2008(outputFolder, method, emotion, outputFilePostExtension);
        emotion = "all";
        this.mainParametricInterspeech2008(outputFolder, method, emotion, outputFilePostExtension);
        method = "3_gmm";
        emotion = "angry";
        this.mainParametricInterspeech2008(outputFolder, method, emotion, outputFilePostExtension);
        emotion = "happy";
        this.mainParametricInterspeech2008(outputFolder, method, emotion, outputFilePostExtension);
        emotion = "sad";
        this.mainParametricInterspeech2008(outputFolder, method, emotion, outputFilePostExtension);
        emotion = "all";
        this.mainParametricInterspeech2008(outputFolder, method, emotion, outputFilePostExtension);
        System.out.println("Objective test completed...");
    }

    public void mainHmmVoiceConversion() throws IOException {
        String baseInputFolder = "D:/Oytun/DFKI/voices/hmmVoiceConversionTest2/output/final/";
        String baseOutputFolder = "D:/Oytun/DFKI/voices/hmmVoiceConversionTest2/objective_test/";
        boolean isBark = true;
        String referenceFolder = "D:/Oytun/DFKI/voices/hmmVoiceConversionTest2/output/final/origTarget";
        String method1 = "NOGV";
        String method2 = "GV";
        String folder1 = baseInputFolder + "hmmSource_nogv";
        String folder2 = baseInputFolder + "hmmSource_gv";
        String outputFile = baseOutputFolder + "IS_" + method1 + "_" + method2 + ".txt";
        String infoString = method1 + " " + method2;
        this.mainParametric(folder1, folder2, referenceFolder, outputFile, infoString);
        method1 = "NOGV";
        method2 = "NOGV+SC";
        folder1 = baseInputFolder + "hmmSource_nogv";
        folder2 = baseInputFolder + "tfm_nogv_1092files_128mixes";
        outputFile = baseOutputFolder + "IS_" + method1 + "_" + method2 + ".txt";
        infoString = method1 + " " + method2;
        this.mainParametric(folder1, folder2, referenceFolder, outputFile, infoString);
        method1 = "GV";
        method2 = "GV+SC";
        folder1 = baseInputFolder + "hmmSource_gv";
        folder2 = baseInputFolder + "tfm_gv_1092files_128mixes";
        outputFile = baseOutputFolder + "IS_" + method1 + "_" + method2 + ".txt";
        infoString = method1 + " " + method2;
        this.mainParametric(folder1, folder2, referenceFolder, outputFile, infoString);
        System.out.println("Objective test completed...");
    }

    public static void main(String[] args) throws IOException {
        ItakuraSaitoDistanceComputer d = new ItakuraSaitoDistanceComputer();
        d.mainHmmVoiceConversion();
    }
}

