/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.ui;

import com.rapidminer.gui.look.RapidLookTools;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;

public class RadioButtonUI
extends BasicRadioButtonUI {
    private static final RadioButtonUI radioButtonUI = new RadioButtonUI();
    private static final BasicStroke DASHED_STROKE = new BasicStroke(1.0f, 0, 0, 6.0f, new float[]{2.0f}, 2.0f);
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;
    private boolean initialized = false;

    protected Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    protected void paintText(Graphics g, AbstractButton c, Rectangle textRect, String text) {
        super.paintText(g, c, textRect, text);
    }

    public void installDefaults(AbstractButton abstractbutton) {
        super.installDefaults(abstractbutton);
        if (!this.initialized) {
            this.icon = UIManager.getIcon(String.valueOf(this.getPropertyPrefix()) + "icon");
            this.initialized = true;
        }
        abstractbutton.setRolloverEnabled(true);
    }

    protected void uninstallDefaults(AbstractButton abstractbutton) {
        super.uninstallDefaults(abstractbutton);
        this.initialized = false;
    }

    public static ComponentUI createUI(JComponent jcomponent) {
        return radioButtonUI;
    }

    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(30, 22);
    }

    protected void paintFocus(Graphics g, Rectangle textRect, Dimension d) {
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        int arc = 14;
        x = (int)textRect.getX() - 2;
        y = (int)textRect.getY();
        w = (int)textRect.getWidth() + 4;
        h = (int)textRect.getHeight();
        if (d.height < 20) {
            arc = 6;
        }
        g.setColor(RapidLookTools.getColors().getCommonFocusColor());
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setStroke(DASHED_STROKE);
        g2.draw(new RoundRectangle2D.Double(x, y, w, h, arc, arc));
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
    }
}

