/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableKernelModelAdapter;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.gui.plotter.PlotterPanel;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.JRadioSelectionPanel;
import com.rapidminer.gui.viewer.DataTableViewerTable;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.functions.kernel.SupportVector;
import java.awt.Component;
import javax.swing.JLabel;

public abstract class KernelModel
extends PredictionModel {
    private static final long serialVersionUID = 7480153570564620067L;
    private String[] attributeConstructions;

    public KernelModel(ExampleSet exampleSet) {
        super(exampleSet);
        this.attributeConstructions = Tools.getRegularAttributeConstructions(exampleSet);
    }

    public abstract double getBias();

    public abstract double getAlpha(int var1);

    public abstract double getFunctionValue(int var1);

    public abstract boolean isClassificationModel();

    public abstract String getClassificationLabel(int var1);

    public abstract double getRegressionLabel(int var1);

    public abstract String getId(int var1);

    public abstract SupportVector getSupportVector(int var1);

    public abstract int getNumberOfSupportVectors();

    public abstract int getNumberOfAttributes();

    public abstract double getAttributeValue(int var1, int var2);

    public String[] getAttributeConstructions() {
        return this.attributeConstructions;
    }

    public String getName() {
        return "Kernel Model";
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Total number of Support Vectors: " + this.getNumberOfSupportVectors() + com.rapidminer.tools.Tools.getLineSeparator());
        result.append("Bias (offset): " + com.rapidminer.tools.Tools.formatNumber(this.getBias()) + com.rapidminer.tools.Tools.getLineSeparators(2));
        if (!this.getLabel().isNominal() || this.getLabel().getMapping().size() == 2) {
            double[] w = new double[this.getNumberOfAttributes()];
            boolean showWeights = true;
            int i = 0;
            while (i < this.getNumberOfSupportVectors()) {
                SupportVector sv = this.getSupportVector(i);
                if (sv != null) {
                    double[] x = sv.getX();
                    double alpha = sv.getAlpha();
                    double y = sv.getY();
                    int j = 0;
                    while (j < w.length) {
                        int n = j;
                        w[n] = w[n] + y * alpha * x[j];
                        ++j;
                    }
                } else {
                    showWeights = false;
                }
                ++i;
            }
            if (showWeights) {
                int j = 0;
                while (j < w.length) {
                    result.append("w[" + this.attributeConstructions[j] + "] = " + com.rapidminer.tools.Tools.formatNumber(w[j]) + com.rapidminer.tools.Tools.getLineSeparator());
                    ++j;
                }
            }
        } else {
            result.append("Feature weight calculation only possible for two class learning problems." + com.rapidminer.tools.Tools.getLineSeparator() + "Please use the operator SVMWeighting instead." + com.rapidminer.tools.Tools.getLineSeparator());
        }
        return result.toString();
    }

    public DataTable createWeightsTable() {
        SimpleDataTable weightTable = new SimpleDataTable("Kernel Model Weights", new String[]{"Attribute", "Weight"});
        if (!this.getLabel().isNominal() || this.getLabel().getMapping().size() == 2) {
            double[] w = new double[this.getNumberOfAttributes()];
            boolean showWeights = true;
            int i = 0;
            while (i < this.getNumberOfSupportVectors()) {
                SupportVector sv = this.getSupportVector(i);
                if (sv != null) {
                    double[] x = sv.getX();
                    double alpha = sv.getAlpha();
                    double y = sv.getY();
                    int j = 0;
                    while (j < w.length) {
                        int n = j;
                        w[n] = w[n] + y * alpha * x[j];
                        ++j;
                    }
                } else {
                    showWeights = false;
                }
                ++i;
            }
            if (showWeights) {
                int j = 0;
                while (j < w.length) {
                    int nameIndex = weightTable.mapString(0, this.attributeConstructions[j]);
                    weightTable.add(new SimpleDataTableRow(new double[]{nameIndex, w[j]}));
                    ++j;
                }
                return weightTable;
            }
            return null;
        }
        return null;
    }

    public Component getVisualizationComponent(IOContainer container) {
        JRadioSelectionPanel mainPanel = new JRadioSelectionPanel();
        Component textView = super.getVisualizationComponent(container);
        mainPanel.addComponent("Text View", textView, "Changes to a textual view of this model.");
        DataTable weightDataTable = this.createWeightsTable();
        if (weightDataTable != null) {
            DataTableViewerTable weightTableViewer = new DataTableViewerTable(true);
            weightTableViewer.setDataTable(weightDataTable);
            ExtendedJScrollPane weightTableView = new ExtendedJScrollPane(weightTableViewer);
            mainPanel.addComponent("Weight Table View", weightTableView, "Changes to a weight table view of this model.");
        } else {
            mainPanel.addComponent("Weight Table View", new ExtendedJScrollPane(new JLabel("Calculation of a weight table only possible for regression or binominal classification tasks.")), "Changes to a weight table view of this model.");
        }
        DataTableKernelModelAdapter supportVectorDataTable = new DataTableKernelModelAdapter(this);
        DataTableViewerTable supportVectorTableViewer = new DataTableViewerTable(false);
        supportVectorTableViewer.setDataTable(supportVectorDataTable);
        ExtendedJScrollPane supportVectorTableView = new ExtendedJScrollPane(supportVectorTableViewer);
        mainPanel.addComponent("Support Vector Table View", supportVectorTableView, "Changes to a support vector table view of this model.");
        PlotterPanel panel = new PlotterPanel(supportVectorDataTable, PlotterPanel.DATA_SET_PLOTTER_SELECTION);
        ExtendedJScrollPane graphView = new ExtendedJScrollPane(panel);
        mainPanel.addComponent("Plot View", graphView, "Changes to a plot view of this model.");
        return mainPanel;
    }
}

