/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

import java.util.Arrays;

public class VectorMath {
    public static final double[] vectorSubtraction(double[] x, double[] y) {
        if (y == null || x == null) {
            throw new RuntimeException("Cannot substract vectors: one vector is null");
        }
        if (x.length != y.length) {
            throw new RuntimeException("Cannot substract vectors: incompatible numbers of attributes (" + x.length + " != " + y.length + ")!");
        }
        double[] result = new double[x.length];
        int i = 0;
        while (i < x.length) {
            result[i] = x[i] - y[i];
            ++i;
        }
        return result;
    }

    public static final double[] vectorAddition(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new RuntimeException("Cannot add vectors: incompatible numbers of attributes (" + x.length + " != " + y.length + ")!");
        }
        double[] result = new double[x.length];
        int i = 0;
        while (i < x.length) {
            result[i] = x[i] + y[i];
            ++i;
        }
        return result;
    }

    public static final double vectorMultiplication(double[] vec1, double[] vec2) {
        if (vec1.length != vec2.length) {
            throw new RuntimeException("Cannot multiply vectors: incompatible numbers of attributes (" + vec1.length + " != " + vec2.length + ")!");
        }
        double resultEven = 0.0;
        double resultOdd = 0.0;
        int until = vec1.length - vec1.length % 2;
        int jEven = 0;
        while (jEven < until) {
            int jOdd = jEven + 1;
            resultEven += vec1[jEven] * vec2[jEven];
            resultOdd += vec1[jOdd] * vec2[jOdd];
            jEven += 2;
        }
        if (vec1.length % 2 == 1) {
            return resultEven + resultOdd + vec1[vec1.length - 1] * vec2[vec1.length - 1];
        }
        return resultEven + resultOdd;
    }

    public static final double[] vectorMultiplication(double[] x, double y) {
        double[] result = new double[x.length];
        int i = 0;
        while (i < x.length) {
            result[i] = x[i] * y;
            ++i;
        }
        return result;
    }

    public static final double[] vectorDivision(double[] x, double y) {
        double[] result = new double[x.length];
        int i = 0;
        while (i < x.length) {
            result[i] = x[i] / y;
            ++i;
        }
        return result;
    }

    public static final double[][] matrixDivision(double[][] x, double y) {
        double[][] result = null;
        if (x.length != 0) {
            result = new double[x.length][x[0].length];
            int i = 0;
            while (i < x.length) {
                int j = 0;
                while (j < x[0].length) {
                    result[i][j] = x[i][j] / y;
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    public static final double[] polynomialExpansion(double[] x, int degree) {
        double[] result = new double[VectorMath.getPolynomialExpansionSize(x.length, degree)];
        int current = 0;
        result[current++] = 1.0;
        int currentDegree = 1;
        while (currentDegree <= degree) {
            int[] counter = new int[currentDegree];
            while (true) {
                double currentResult = x[counter[0]];
                int currentCounter = 1;
                while (currentCounter < currentDegree) {
                    currentResult *= x[counter[currentCounter]];
                    ++currentCounter;
                }
                result[current] = currentResult;
                ++current;
                if (VectorMath.isLastPosition(counter, x.length)) break;
                counter[0] = counter[0] + 1;
                if (counter[0] != x.length) continue;
                counter[0] = VectorMath.moveCounterAhead(counter, 1, x.length);
            }
            ++currentDegree;
        }
        return result;
    }

    private static final int moveCounterAhead(int[] counter, int counterPos, int numberOfComponents) {
        int n = counterPos;
        counter[n] = counter[n] + 1;
        if (counter[counterPos] == numberOfComponents) {
            counter[counterPos] = VectorMath.moveCounterAhead(counter, counterPos + 1, numberOfComponents);
        }
        return counter[counterPos];
    }

    private static final boolean isLastPosition(int[] counter, int numberOfElements) {
        int i = 0;
        while (i < counter.length) {
            if (counter[i] < numberOfElements - 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final int getPolynomialExpansionSize(int numberOfComponents, int degree) {
        int[] result = new int[numberOfComponents];
        Arrays.fill(result, 1);
        int totalSum = 1;
        int currentDegree = 1;
        while (currentDegree <= degree) {
            int i = 0;
            while (i < result.length) {
                totalSum += result[i];
                int sum = 0;
                int j = i;
                while (j < result.length) {
                    sum += result[j];
                    ++j;
                }
                result[i] = sum;
                ++i;
            }
            ++currentDegree;
        }
        return totalSum;
    }

    public static final double getMedian(double[] residuals) {
        double[] copy = (double[])residuals.clone();
        Arrays.sort(copy);
        return copy[copy.length / 2];
    }
}

