/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AbstractExampleSet;
import com.rapidminer.example.set.IndexBasedExampleSetReader;
import com.rapidminer.example.set.Partition;
import com.rapidminer.example.set.PartitionBuilder;
import com.rapidminer.example.set.ShuffledPartitionBuilder;
import com.rapidminer.example.set.SimplePartitionBuilder;
import com.rapidminer.example.set.StratifiedPartitionBuilder;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.tools.Tools;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplittedExampleSet
extends AbstractExampleSet {
    private static final long serialVersionUID = 4573262969007377183L;
    public static final String[] SAMPLING_NAMES = new String[]{"linear sampling", "shuffled sampling", "stratified sampling"};
    public static final int LINEAR_SAMPLING = 0;
    public static final int SHUFFLED_SAMPLING = 1;
    public static final int STRATIFIED_SAMPLING = 2;
    private Partition partition;
    private ExampleSet parent;

    public SplittedExampleSet(ExampleSet exampleSet, Partition partition) {
        this.parent = (ExampleSet)exampleSet.clone();
        this.partition = partition;
    }

    public SplittedExampleSet(ExampleSet exampleSet, double splitRatio, int samplingType, int seed) {
        this(exampleSet, new double[]{splitRatio, 1.0 - splitRatio}, samplingType, seed);
    }

    public SplittedExampleSet(ExampleSet exampleSet, double[] splitRatios, int samplingType, int seed) {
        this(exampleSet, new Partition(splitRatios, exampleSet.size(), SplittedExampleSet.createPartitionBuilder(exampleSet, samplingType, seed)));
    }

    public SplittedExampleSet(ExampleSet exampleSet, int numberOfSubsets, int samplingType, int seed) {
        this(exampleSet, new Partition(numberOfSubsets, exampleSet.size(), SplittedExampleSet.createPartitionBuilder(exampleSet, samplingType, seed)));
    }

    public SplittedExampleSet(SplittedExampleSet exampleSet) {
        this.parent = (ExampleSet)exampleSet.parent.clone();
        this.partition = (Partition)exampleSet.partition.clone();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof SplittedExampleSet)) {
            return false;
        }
        return this.partition.equals(((SplittedExampleSet)o).partition);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.partition.hashCode();
    }

    private static PartitionBuilder createPartitionBuilder(ExampleSet exampleSet, int samplingType, int seed) {
        PartitionBuilder builder = null;
        switch (samplingType) {
            case 0: {
                builder = new SimplePartitionBuilder();
                break;
            }
            case 1: {
                builder = new ShuffledPartitionBuilder(seed);
                break;
            }
            default: {
                Attribute label = exampleSet.getAttributes().getLabel();
                if (label != null && label.isNominal()) {
                    builder = new StratifiedPartitionBuilder(exampleSet, seed);
                    break;
                }
                exampleSet.getLog().logNote("Example set has no nominal label: using shuffled partition instead of stratified partition!");
                builder = new ShuffledPartitionBuilder(seed);
            }
        }
        return builder;
    }

    public void selectAdditionalSubset(int index) {
        this.partition.selectSubset(index);
    }

    public void selectSingleSubset(int index) {
        this.partition.clearSelection();
        this.partition.selectSubset(index);
    }

    public void selectAllSubsetsBut(int index) {
        this.partition.clearSelection();
        int i = 0;
        while (i < this.partition.getNumberOfSubsets()) {
            if (i != index) {
                this.partition.selectSubset(i);
            }
            ++i;
        }
    }

    public void selectAllSubsets() {
        this.partition.clearSelection();
        int i = 0;
        while (i < this.partition.getNumberOfSubsets()) {
            this.partition.selectSubset(i);
            ++i;
        }
    }

    public void invertSelection() {
        this.partition.invertSelection();
    }

    public void clearSelection() {
        this.partition.clearSelection();
    }

    public int getNumberOfSubsets() {
        return this.partition.getNumberOfSubsets();
    }

    @Override
    public Iterator<Example> iterator() {
        return new IndexBasedExampleSetReader(this);
    }

    @Override
    public int size() {
        return this.partition.getSelectionSize();
    }

    @Override
    public Example getExample(int index) {
        int actualIndex = this.partition.mapIndex(index);
        return this.parent.getExample(actualIndex);
    }

    public int getActualParentIndex(int index) {
        return this.partition.mapIndex(index);
    }

    @Override
    public ExampleTable getExampleTable() {
        return this.parent.getExampleTable();
    }

    @Override
    public Attributes getAttributes() {
        return this.parent.getAttributes();
    }

    public static SplittedExampleSet splitByAttribute(ExampleSet exampleSet, Attribute attribute) {
        int[] elements = new int[exampleSet.size()];
        int i = 0;
        HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
        AtomicInteger currentIndex = new AtomicInteger(0);
        for (Example example : exampleSet) {
            int value = (int)example.getValue(attribute);
            Integer indexObject = (Integer)indexMap.get(value);
            if (indexObject == null) {
                indexMap.put(value, currentIndex.getAndIncrement());
            }
            int intValue = (Integer)indexMap.get(value);
            elements[i++] = intValue;
        }
        int maxNumber = indexMap.size();
        indexMap.clear();
        Partition partition = new Partition(elements, maxNumber);
        return new SplittedExampleSet(exampleSet, partition);
    }

    public static SplittedExampleSet splitByAttribute(ExampleSet exampleSet, Attribute attribute, double value) {
        int[] elements = new int[exampleSet.size()];
        Iterator reader = exampleSet.iterator();
        int i = 0;
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            double currentValue = example.getValue(attribute);
            elements[i++] = Tools.isLessEqual(currentValue, value) ? 0 : 1;
        }
        Partition partition = new Partition(elements, 2);
        return new SplittedExampleSet(exampleSet, partition);
    }
}

