/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.matrix;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;

public class CovarianceMatrix {
    public static Matrix getCovarianceMatrix(ExampleSet exampleSet) {
        double[][] data = new double[exampleSet.size()][exampleSet.getAttributes().size()];
        int r = 0;
        for (Example example : exampleSet) {
            int c = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                data[r][c] = example.getValue(attribute);
                ++c;
            }
            ++r;
        }
        return CovarianceMatrix.getCovarianceMatrix(data);
    }

    public static Matrix getCovarianceMatrix(double[][] data) {
        if (data.length == 0) {
            throw new IllegalArgumentException("Calculation of covariance matrices not possible for data sets with zero rows.");
        }
        int numberOfColumns = -1;
        int r = 0;
        while (r < data.length) {
            if (numberOfColumns < 0) {
                numberOfColumns = data[r].length;
            } else if (numberOfColumns != data[r].length) {
                throw new IllegalArgumentException("Calculation of covariance matrices not possible for data sets with different numbers of columns.");
            }
            ++r;
        }
        if (numberOfColumns <= 0) {
            throw new IllegalArgumentException("Calculation of covariance matrices not possible for data sets with zero columns.");
        }
        int c = 0;
        while (c < numberOfColumns) {
            double average = CovarianceMatrix.getAverageForColumn(data, c);
            int r2 = 0;
            while (r2 < data.length) {
                double[] dArray = data[r2];
                int n = c;
                dArray[n] = dArray[n] - average;
                ++r2;
            }
            ++c;
        }
        double[][] covarianceMatrixEntries = new double[numberOfColumns][numberOfColumns];
        int i = 0;
        while (i < covarianceMatrixEntries.length) {
            int j = i;
            while (j < covarianceMatrixEntries.length) {
                double covariance;
                covarianceMatrixEntries[i][j] = covariance = CovarianceMatrix.getCovariance(data, i, j);
                covarianceMatrixEntries[j][i] = covariance;
                ++j;
            }
            ++i;
        }
        return new Matrix(covarianceMatrixEntries);
    }

    private static double getAverageForColumn(double[][] data, int column) {
        double sum = 0.0;
        int r = 0;
        while (r < data.length) {
            sum += data[r][column];
            ++r;
        }
        return sum / (double)data.length;
    }

    private static double getCovariance(double[][] data, int x, int y) {
        double cov = 0.0;
        int i = 0;
        while (i < data.length) {
            cov += data[i][x] * data[i][y];
            ++i;
        }
        return cov / (double)(data.length - 1);
    }
}

