/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.relp;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Sample {
    private short[] frameData;
    private byte[] residualData;
    private int residualSize;
    private int frameDataSize;
    private int numChannels;
    private int start;
    private int startRes;
    private ByteBuffer byteBuffer;
    private boolean haveFrameData = true;
    private boolean haveResData = true;

    public Sample(short[] frameData, byte[] residualData) {
        this.frameData = frameData;
        this.residualData = residualData;
    }

    public Sample(short[] frameData, byte[] residualData, int residualSize) {
        this.frameData = frameData;
        this.residualData = residualData;
        this.residualSize = residualSize;
    }

    public Sample(BufferedReader reader, int numChannels) {
        try {
            int i;
            String line = reader.readLine();
            StringTokenizer tok = new StringTokenizer(line);
            if (!tok.nextToken().equals("FRAME")) {
                throw new Error("frame Parsing sample error");
            }
            this.frameData = new short[numChannels];
            for (i = 0; i < numChannels; ++i) {
                int svalue = Integer.parseInt(tok.nextToken()) - 32768;
                if (svalue < Short.MIN_VALUE || svalue > Short.MAX_VALUE) {
                    throw new Error("data out of short range");
                }
                this.frameData[i] = (short)svalue;
            }
            line = reader.readLine();
            tok = new StringTokenizer(line);
            if (!tok.nextToken().equals("RESIDUAL")) {
                throw new Error("residual Parsing sample error");
            }
            this.residualSize = Integer.parseInt(tok.nextToken());
            this.residualData = new byte[this.residualSize];
            for (i = 0; i < this.residualSize; ++i) {
                int bvalue = Integer.parseInt(tok.nextToken()) - 128;
                if (bvalue < -128 || bvalue > 127) {
                    throw new Error("data out of byte range");
                }
                this.residualData[i] = (byte)bvalue;
            }
        }
        catch (NoSuchElementException nse) {
            throw new Error("Parsing sample error " + nse.getMessage());
        }
        catch (IOException ioe) {
            throw new Error("IO error while parsing sample" + ioe.getMessage());
        }
    }

    public Sample(ByteBuffer bb, int start, int startRes, int resSize, int frameSize) throws IOException {
        this.byteBuffer = bb;
        this.start = start;
        this.startRes = startRes;
        this.residualSize = resSize;
        this.frameDataSize = frameSize;
        this.haveFrameData = false;
        this.haveResData = false;
    }

    public short[] getFrameData() {
        if (!this.haveFrameData) {
            short[] frames = new short[this.frameDataSize];
            this.byteBuffer.position(this.start);
            for (int i = 0; i < frames.length; ++i) {
                frames[i] = this.byteBuffer.getShort();
            }
            return frames;
        }
        return this.frameData;
    }

    public byte[] getResidualData() {
        if (!this.haveResData) {
            byte[] res = new byte[this.residualSize];
            this.byteBuffer.position(this.startRes);
            for (int i = 0; i < res.length; ++i) {
                res[i] = this.byteBuffer.get();
            }
            return res;
        }
        return this.residualData;
    }

    public int getResidualSize() {
        return this.residualSize;
    }

    public int getFrameSize() {
        return this.frameData.length;
    }

    public int getResidualData(int which) {
        if (!this.haveResData) {
            this.byteBuffer.position(this.startRes + which);
            return this.byteBuffer.get() + 128;
        }
        return this.residualData[which] + 128;
    }

    public int getFrameData(int which) {
        if (!this.haveFrameData) {
            this.byteBuffer.position(this.start + which);
            return this.byteBuffer.getShort() + 128;
        }
        return this.frameData[which] + 32768;
    }

    public void dump() {
        int i;
        System.out.println(" FD Count: " + this.getFrameData().length);
        for (i = 0; i < this.getFrameData().length; ++i) {
            System.out.print(" " + this.getFrameData(i));
        }
        System.out.println();
        System.out.println(" RD Count: " + this.getResidualSize());
        for (i = 0; i < this.getResidualData().length; ++i) {
            System.out.print(" " + this.getResidualData(i));
        }
        System.out.println();
    }

    public void dumpBinary(ByteBuffer bb) throws IOException {
        if (!this.haveResData) {
            this.residualData = this.residualData = this.getResidualData();
        }
        if (!this.haveFrameData) {
            this.frameData = this.frameData = this.getFrameData();
        }
        bb.putInt(this.frameData.length);
        for (int i = 0; i < this.frameData.length; ++i) {
            bb.putShort(this.frameData[i]);
        }
        bb.putInt(this.residualData.length);
        bb.put(this.residualData);
    }

    public void dumpBinary(DataOutputStream os, int resSize, int frameSize) throws IOException {
        int i;
        if (!this.haveResData) {
            this.residualData = this.getResidualData();
        }
        if (!this.haveFrameData) {
            this.frameData = this.getFrameData();
        }
        os.writeInt(frameSize);
        for (i = 0; i < this.frameData.length; ++i) {
            os.writeShort(this.frameData[i]);
        }
        os.writeInt(this.residualSize);
        for (i = 0; i < this.residualSize; ++i) {
            os.writeByte(this.residualData[i]);
        }
        byte dummyByte = new Integer(0).byteValue();
        for (int i2 = this.residualSize; i2 < resSize; ++i2) {
            os.writeByte(dummyByte);
        }
    }

    public void dumpBinary(DataOutputStream os) throws IOException {
        int i;
        if (!this.haveResData) {
            this.residualData = this.getResidualData();
        }
        if (!this.haveFrameData) {
            this.frameData = this.getFrameData();
        }
        os.writeInt(this.frameData.length);
        for (i = 0; i < this.frameData.length; ++i) {
            os.writeShort(this.frameData[i]);
        }
        os.writeInt(this.residualData.length);
        for (i = 0; i < this.residualData.length; ++i) {
            os.writeByte(this.residualData[i]);
        }
    }

    public static Sample loadBinary(DataInputStream dis, int resSize, int frameSize) throws IOException {
        int i;
        int i2;
        int frameDataSize = dis.readInt();
        short[] frameData = new short[frameDataSize];
        for (i2 = 0; i2 < frameData.length; ++i2) {
            frameData[i2] = dis.readShort();
        }
        if (frameDataSize < frameSize) {
            for (i2 = frameDataSize; i2 <= frameSize; ++i2) {
                dis.readShort();
            }
        }
        int residualDataSize = dis.readInt();
        byte[] residualData = new byte[residualDataSize];
        for (i = 0; i < residualData.length; ++i) {
            residualData[i] = dis.readByte();
        }
        if (residualDataSize < resSize) {
            for (i = residualDataSize + 1; i <= resSize; ++i) {
                dis.readByte();
            }
        }
        return new Sample(frameData, residualData, residualDataSize);
    }

    public static Sample loadBinary(DataInputStream dis) throws IOException {
        int frameDataSize = dis.readInt();
        short[] frameData = new short[frameDataSize];
        for (int i = 0; i < frameData.length; ++i) {
            frameData[i] = dis.readShort();
        }
        int residualDataSize = dis.readInt();
        byte[] residualData = new byte[residualDataSize];
        for (int i = 0; i < residualData.length; ++i) {
            residualData[i] = dis.readByte();
        }
        return new Sample(frameData, residualData, residualDataSize);
    }

    public boolean compare(Sample other) {
        int i;
        if (!this.haveResData) {
            this.residualData = this.getResidualData();
        }
        if (!this.haveFrameData) {
            this.frameData = this.getFrameData();
        }
        if (this.frameData.length != other.getFrameData().length) {
            return false;
        }
        for (i = 0; i < this.frameData.length; ++i) {
            if (this.frameData[i] == other.frameData[i]) continue;
            return false;
        }
        if (this.residualData.length != other.residualData.length) {
            return false;
        }
        for (i = 0; i < this.residualData.length; ++i) {
            if (this.residualData[i] == other.residualData[i]) continue;
            return false;
        }
        return true;
    }
}

