/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules.acoustic;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureProcessorManager;
import marytts.machinelearning.SoP;
import marytts.modules.acoustic.Model;
import marytts.unitselection.select.Target;
import marytts.util.MaryUtils;

public class SoPModel
extends Model {
    private Map<String, SoP> sopModels;

    public SoPModel(FeatureProcessorManager featureManager, String voiceName, InputStream dataStream, String targetAttributeName, String targetAttributeFormat, String featureName, String predictFrom, String applyTo) throws MaryConfigurationException {
        super(featureManager, voiceName, dataStream, targetAttributeName, targetAttributeFormat, featureName, predictFrom, applyTo);
        this.load();
    }

    @Override
    protected void loadData() throws IOException {
        this.sopModels = new HashMap<String, SoP>();
        String strContext = "";
        Scanner s = null;
        try {
            String nextLine;
            s = new Scanner(new BufferedReader(new InputStreamReader(this.dataStream, "UTF-8")));
            while (s.hasNext() && !(nextLine = s.nextLine()).trim().equals("")) {
                strContext = strContext + nextLine + "\n";
            }
            FeatureDefinition sopFeatureDefinition = new FeatureDefinition(new BufferedReader(new StringReader(strContext)), false);
            this.predictionFeatureNames = sopFeatureDefinition.getFeatureNames();
            while (s.hasNext()) {
                String nextType = s.nextLine();
                nextLine = s.nextLine();
                if (nextType.startsWith("f0")) {
                    this.sopModels.put("f0", new SoP(nextLine, sopFeatureDefinition));
                    continue;
                }
                this.sopModels.put(nextType, new SoP(nextLine, sopFeatureDefinition));
            }
            s.close();
        }
        catch (Exception e) {
            throw new IOException("Error reading SoP data", e);
        }
    }

    @Override
    protected float evaluate(Target target) {
        float result = 0.0f;
        if (this.targetAttributeName.contentEquals("f0")) {
            result = (float)this.sopModels.get("f0").interpret(target);
        } else if (target.getAllophone().isVowel()) {
            result = (float)this.sopModels.get("vowel").interpret(target);
        } else if (target.getAllophone().isConsonant()) {
            result = (float)this.sopModels.get("consonant").interpret(target);
        } else if (target.getAllophone().isPause()) {
            result = (float)this.sopModels.get("pause").interpret(target);
        } else {
            MaryUtils.getLogger("SoPModel").warn("Warning: No SoP model for target " + target.toString());
        }
        return result;
    }
}

