/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.analysis.pitch;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.sinusoidal.hntm.analysis.pitch.HnmPitchVoicingAnalyzerParams;
import marytts.signalproc.sinusoidal.hntm.analysis.pitch.VoicingAnalysisOutputData;
import marytts.signalproc.window.Window;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.display.DisplayUtils;
import marytts.util.math.ArrayUtils;
import marytts.util.math.ComplexArray;
import marytts.util.math.FFT;
import marytts.util.math.FFTMixedRadix;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class HnmPitchVoicingAnalyzer {
    public static int getDefaultFFTSize(int samplingRate) {
        if (samplingRate < 10000) {
            return 2048;
        }
        if (samplingRate < 20000) {
            return 4096;
        }
        return 8192;
    }

    public static float[] estimateInitialPitch(double[] x, int samplingRate, float f0MinInHz, float f0MaxInHz, int windowType, HnmPitchVoicingAnalyzerParams params) {
        int t;
        int PMax = (int)Math.floor((double)((float)samplingRate / f0MinInHz) + 0.5);
        int PMin = (int)Math.floor((double)((float)samplingRate / f0MaxInHz) + 0.5);
        int ws = SignalProcUtils.time2sample(params.mvfAnalysisWindowSizeInSeconds, samplingRate);
        ws = Math.max(ws, (int)Math.floor((double)(params.numPeriodsInitialPitchEstimation * (float)PMin) + 0.5));
        int ss = (int)Math.floor((double)(params.mvfAnalysisSkipSizeInSeconds * (float)samplingRate) + 0.5);
        int numfrm = (int)Math.floor(((double)x.length - (double)ws) / (double)ss + 0.5);
        int numCandidates = PMax - PMin + 1;
        double[] E = new double[numCandidates];
        double[] frm = new double[ws];
        Window win = Window.get(windowType, ws);
        double[] wgt2 = win.getCoeffs();
        wgt2 = MathUtils.normalizeToSumUpTo(wgt2, 1.0);
        for (t = 0; t < ws; ++t) {
            wgt2[t] = wgt2[t] * wgt2[t];
        }
        double tmpSum = 0.0;
        for (t = 0; t < ws; ++t) {
            tmpSum += wgt2[t];
        }
        for (t = 0; t < ws; ++t) {
            wgt2[t] = wgt2[t] / tmpSum;
        }
        double[] wgt4 = new double[ws];
        System.arraycopy(wgt2, 0, wgt4, 0, ws);
        for (t = 0; t < ws; ++t) {
            wgt4[t] = wgt4[t] * wgt4[t];
        }
        double termTmp = 0.0;
        for (t = 0; t < ws; ++t) {
            termTmp += wgt4[t];
        }
        float[] initialF0s = new float[numfrm];
        for (int i = 0; i < numfrm; ++i) {
            Arrays.fill(frm, 0.0);
            System.arraycopy(x, i * ss, frm, 0, Math.min(ws, x.length - i * ss));
            int startIndex = i * ss;
            int endIndex = startIndex + Math.min(ws, x.length - i * ss) - 1;
            double term1 = 0.0;
            for (t = 0; t < ws; ++t) {
                term1 += frm[t] * frm[t] * wgt2[t];
            }
            for (int P = PMin; P <= PMax; ++P) {
                float lLim = (float)ws / (float)P;
                double term2 = 0.0;
                int l = (int)(Math.floor(-1.0f * lLim) + 1.0);
                while ((float)l < lLim) {
                    double r = 0.0;
                    for (t = 0; t < ws; ++t) {
                        if (t + l * P < 0 || t + l * P >= ws) continue;
                        r += frm[t] * wgt2[t] * frm[t + l * P] * wgt2[t + l * P];
                    }
                    term2 += r;
                    ++l;
                }
                double term3 = 1.0 - (double)P * termTmp;
                E[P - PMin] = (term1 - (term2 *= (double)P)) / (term1 * term3);
            }
            int minInd = MathUtils.getMinIndex(E);
            initialF0s[i] = E[minInd] < 0.5 ? 1.0f / SignalProcUtils.sample2time(minInd + PMin, samplingRate) : 0.0f;
        }
        return initialF0s;
    }

    public static float[] analyzeVoicings(double[] x, int samplingRate, float[] initialF0s, HnmPitchVoicingAnalyzerParams params, boolean isSilentAnalysis) {
        double[] xNorm = MathUtils.add(x, -1.0 * MathUtils.mean(x));
        double xEn = SignalProcUtils.energy(x);
        xNorm = MathUtils.multiply(x, 500.0 / Math.sqrt(xEn / (double)x.length));
        double durationInSeconds = SignalProcUtils.sample2time(x.length, samplingRate);
        int numfrm = (int)Math.floor((durationInSeconds - 0.5 * (double)params.mvfAnalysisWindowSizeInSeconds) / (double)params.mvfAnalysisSkipSizeInSeconds + 0.5);
        float[] mappedF0s = new float[numfrm];
        double[] voicingErrors = new double[numfrm];
        int ws = SignalProcUtils.time2sample(params.mvfAnalysisWindowSizeInSeconds, samplingRate);
        int ss = (int)Math.floor((double)(params.mvfAnalysisSkipSizeInSeconds * (float)samplingRate) + 0.5);
        float[] maxFrequencyOfVoicings = new float[numfrm];
        double[] frm = new double[ws];
        Window w = Window.get(3, ws);
        while (params.fftSize < ws) {
            params.fftSize *= 2;
        }
        int maxFreq = (int)(Math.floor(0.5 * (double)params.fftSize + 0.5) + 1.0);
        ComplexArray Y = new ComplexArray(params.fftSize);
        double[][] allDBSpectra = new double[numfrm][maxFreq];
        for (int i = 0; i < numfrm; ++i) {
            Arrays.fill(frm, 0.0);
            if (i * ss + ws < x.length) {
                System.arraycopy(xNorm, i * ss, frm, 0, ws);
            } else {
                System.arraycopy(xNorm, x.length - ws, frm, 0, ws);
            }
            frm = w.apply(frm, 0);
            int startIndex = i * ss;
            int endIndex = startIndex + Math.min(ws, x.length - i * ss) - 1;
            float currentTime = (float)i * params.mvfAnalysisSkipSizeInSeconds + 0.5f * params.mvfAnalysisWindowSizeInSeconds;
            int currentF0Index = SignalProcUtils.time2frameIndex(currentTime, params.f0AnalysisWindowSizeInSeconds, params.f0AnalysisSkipSizeInSeconds);
            currentF0Index = MathUtils.CheckLimits(currentF0Index, 0, initialF0s.length - 1);
            mappedF0s[i] = initialF0s[currentF0Index];
            Arrays.fill(Y.real, 0.0);
            Arrays.fill(Y.imag, 0.0);
            System.arraycopy(frm, 0, Y.real, 0, frm.length);
            if (MathUtils.isPowerOfTwo(params.fftSize)) {
                FFT.transform(Y.real, Y.imag, false);
            } else {
                Y = FFTMixedRadix.fftComplex(Y);
            }
            double[] YAbs = MathUtils.abs(Y, 0, maxFreq - 1);
            double[] YAbsDB = MathUtils.amp2db(YAbs);
            allDBSpectra[i] = ArrayUtils.copy(YAbsDB);
            boolean isVoiced = mappedF0s[i] > 10.0f;
            VoicingAnalysisOutputData vo = null;
            if (isVoiced) {
                float prevMaxFreqVoicing = 0.0f;
                float prevPrevMaxFreqVoicing = 0.0f;
                if (i >= 1) {
                    prevMaxFreqVoicing = maxFrequencyOfVoicings[i - 1];
                }
                if (i >= 2) {
                    prevPrevMaxFreqVoicing = maxFrequencyOfVoicings[i - 2];
                }
                vo = HnmPitchVoicingAnalyzer.estimateMaxFrequencyOfVoicingsFrame(YAbsDB, samplingRate, mappedF0s[i], isVoiced, prevMaxFreqVoicing, prevPrevMaxFreqVoicing, params, isSilentAnalysis);
                maxFrequencyOfVoicings[i] = vo.maxFreqOfVoicing;
            } else {
                maxFrequencyOfVoicings[i] = 0.0f;
            }
            if (isSilentAnalysis) continue;
            if (isVoiced) {
                System.out.println("Time=" + String.valueOf(currentTime) + " sec." + " f0=" + String.valueOf(mappedF0s[i]) + " Hz." + " Voiced" + " MaxVFreq=" + String.valueOf(maxFrequencyOfVoicings[i]));
                continue;
            }
            System.out.println("Time=" + String.valueOf(currentTime) + " sec." + " f0=" + String.valueOf(mappedF0s[i]) + " Hz." + " Unvoiced" + " MaxVFreq=" + String.valueOf(maxFrequencyOfVoicings[i]));
        }
        maxFrequencyOfVoicings = HnmPitchVoicingAnalyzer.smoothUsingPeaks(maxFrequencyOfVoicings);
        maxFrequencyOfVoicings = HnmPitchVoicingAnalyzer.smoothUsingFilters(maxFrequencyOfVoicings, params);
        maxFrequencyOfVoicings = HnmPitchVoicingAnalyzer.applyConstraints(maxFrequencyOfVoicings, mappedF0s, samplingRate, params);
        return maxFrequencyOfVoicings;
    }

    public static float[] smoothUsingFilters(float[] maxFrequencyOfVoicings, HnmPitchVoicingAnalyzerParams params) {
        for (int i = 0; i < params.numFilteringStages; ++i) {
            if (params.medianFilterLength > 1) {
                maxFrequencyOfVoicings = SignalProcUtils.medianFilter(maxFrequencyOfVoicings, params.medianFilterLength);
            }
            if (params.movingAverageFilterLength <= 1) continue;
            maxFrequencyOfVoicings = SignalProcUtils.meanFilter(maxFrequencyOfVoicings, params.movingAverageFilterLength);
        }
        return maxFrequencyOfVoicings;
    }

    public static float[] smoothUsingPeaks(float[] maxFrequencyOfVoicings) {
        int i;
        int numSegments = 0;
        boolean bSegmentStarted = false;
        int startInd = -1;
        int endInd = -1;
        if ((double)maxFrequencyOfVoicings[0] > 10.0 && (double)maxFrequencyOfVoicings[1] > 10.0) {
            startInd = 0;
            bSegmentStarted = true;
        }
        for (i = 2; i < maxFrequencyOfVoicings.length; ++i) {
            if (!bSegmentStarted) {
                if (!((double)maxFrequencyOfVoicings[i - 2] < 10.0) || !((double)maxFrequencyOfVoicings[i - 1] < 10.0) || !((double)maxFrequencyOfVoicings[i] > 10.0)) continue;
                bSegmentStarted = true;
                startInd = i;
                continue;
            }
            if (!((double)maxFrequencyOfVoicings[i] < 10.0)) continue;
            bSegmentStarted = false;
            endInd = i;
            if (endInd - startInd > 5) {
                ++numSegments;
            }
            startInd = -1;
            endInd = -1;
        }
        if (numSegments > 0) {
            float[] tmpMaxFrequencyOfVoicings = ArrayUtils.copy(maxFrequencyOfVoicings);
            Arrays.fill(maxFrequencyOfVoicings, 0.0f);
            int[][] segmentInds = new int[numSegments][2];
            int currentSegment = 0;
            bSegmentStarted = false;
            startInd = -1;
            endInd = -1;
            if ((double)tmpMaxFrequencyOfVoicings[0] > 10.0 && (double)tmpMaxFrequencyOfVoicings[1] > 10.0) {
                startInd = 0;
                bSegmentStarted = true;
            }
            for (i = 2; i < tmpMaxFrequencyOfVoicings.length; ++i) {
                if (!bSegmentStarted) {
                    if (!((double)tmpMaxFrequencyOfVoicings[i - 2] < 10.0) || !((double)tmpMaxFrequencyOfVoicings[i - 1] < 10.0) || !((double)tmpMaxFrequencyOfVoicings[i] > 10.0)) continue;
                    bSegmentStarted = true;
                    startInd = i;
                    continue;
                }
                if (!((double)tmpMaxFrequencyOfVoicings[i] < 10.0)) continue;
                bSegmentStarted = false;
                endInd = i;
                if (endInd - startInd > 5) {
                    segmentInds[currentSegment][0] = startInd;
                    segmentInds[currentSegment][1] = endInd;
                }
                startInd = -1;
                endInd = -1;
                if (++currentSegment > numSegments - 1) break;
            }
            for (i = 0; i < numSegments; ++i) {
                int j;
                double[] tmpSegment = new double[segmentInds[i][1] - segmentInds[i][0] + 1];
                for (j = segmentInds[i][0]; j <= segmentInds[i][1]; ++j) {
                    tmpSegment[j - segmentInds[i][0]] = tmpMaxFrequencyOfVoicings[j];
                }
                int[] tmpPeakInds = MathUtils.getExtrema(tmpSegment, 3, 3, true);
                int[] peakInds = null;
                boolean peakIndsLen = false;
                if (tmpPeakInds != null) {
                    peakInds = new int[tmpPeakInds.length + 2];
                    peakInds[0] = 0;
                    for (j = 0; j < tmpPeakInds.length; ++j) {
                        peakInds[j + 1] = tmpPeakInds[j];
                    }
                    peakInds[peakInds.length - 1] = segmentInds[i][1] - segmentInds[i][0];
                }
                if (peakInds != null) {
                    j = 0;
                    while (j < peakInds.length) {
                        int n = j++;
                        peakInds[n] = peakInds[n] + segmentInds[i][0];
                    }
                    double[] peakVals = new double[peakInds.length];
                    for (j = 0; j < peakInds.length; ++j) {
                        peakVals[j] = tmpMaxFrequencyOfVoicings[peakInds[j]];
                    }
                    int[] inds = new int[segmentInds[i][1] - segmentInds[i][0] + 1];
                    for (j = segmentInds[i][0]; j <= segmentInds[i][1]; ++j) {
                        inds[j - segmentInds[i][0]] = j;
                    }
                    tmpSegment = MathUtils.interpolate_linear(peakInds, peakVals, inds);
                    for (j = segmentInds[i][0]; j <= segmentInds[i][1]; ++j) {
                        maxFrequencyOfVoicings[j] = (float)tmpSegment[j - segmentInds[i][0]];
                    }
                    continue;
                }
                for (j = segmentInds[i][0]; j <= segmentInds[i][1]; ++j) {
                    maxFrequencyOfVoicings[j] = tmpMaxFrequencyOfVoicings[j];
                }
            }
        }
        return maxFrequencyOfVoicings;
    }

    public static float[] applyConstraints(float[] maxFrequencyOfVoicings, float[] mappedF0s, int samplingRate, HnmPitchVoicingAnalyzerParams params) {
        int i;
        for (i = 0; i < maxFrequencyOfVoicings.length; ++i) {
            if (!(mappedF0s[i] < 10.0f)) continue;
            maxFrequencyOfVoicings[i] = 0.0f;
        }
        for (i = 0; i < maxFrequencyOfVoicings.length; ++i) {
            if (mappedF0s[i] < 10.0f) {
                maxFrequencyOfVoicings[i] = 0.0f;
                continue;
            }
            maxFrequencyOfVoicings[i] = MathUtils.CheckLimits(maxFrequencyOfVoicings[i], (float)params.minimumTotalHarmonics * mappedF0s[i] - 0.3f * mappedF0s[i], (float)params.maximumTotalHarmonics * mappedF0s[i] + 0.3f * mappedF0s[i]);
            maxFrequencyOfVoicings[i] = MathUtils.CheckLimits(maxFrequencyOfVoicings[i], params.minimumVoicedFrequencyOfVoicing, params.maximumVoicedFrequencyOfVoicing);
        }
        maxFrequencyOfVoicings = MathUtils.add(maxFrequencyOfVoicings, params.maximumFrequencyOfVoicingFinalShift);
        for (i = 0; i < maxFrequencyOfVoicings.length; ++i) {
            maxFrequencyOfVoicings[i] = mappedF0s[i] < 10.0f ? 0.0f : MathUtils.CheckLimits(maxFrequencyOfVoicings[i], 0.0f, 0.5f * (float)samplingRate);
        }
        for (i = 0; i < maxFrequencyOfVoicings.length; ++i) {
            if (!(mappedF0s[i] < 10.0f)) continue;
            maxFrequencyOfVoicings[i] = 0.0f;
        }
        return maxFrequencyOfVoicings;
    }

    public static VoicingAnalysisOutputData estimateMaxFrequencyOfVoicingsFrame(double[] absDBSpec, int samplingRate, float f0, boolean isVoiced, HnmPitchVoicingAnalyzerParams params) {
        return HnmPitchVoicingAnalyzer.estimateMaxFrequencyOfVoicingsFrame(absDBSpec, samplingRate, f0, isVoiced, -1.0f, -1.0f, params, false);
    }

    public static VoicingAnalysisOutputData estimateMaxFrequencyOfVoicingsFrame(double[] absDBSpec, int samplingRate, float f0, boolean isVoiced, float prevMaxFreqVoicing, float prevPrevMaxFreqVoicing, HnmPitchVoicingAnalyzerParams params, boolean isSilentAnalysis) {
        int i;
        VoicingAnalysisOutputData output = new VoicingAnalysisOutputData();
        output.maxFreqOfVoicing = 0.0f;
        if (!isVoiced) {
            f0 = 100.0f;
        }
        int maxFreqIndex = absDBSpec.length - 1;
        int numHarmonics = (int)Math.floor((0.5 * (double)samplingRate - 1.5 * (double)f0) / (double)f0 + 0.5);
        int[] bandInds = new int[numHarmonics + 1];
        for (i = 0; i < bandInds.length; ++i) {
            bandInds[i] = SignalProcUtils.freq2index(((double)i + 0.5) * (double)f0, (double)samplingRate, maxFreqIndex);
        }
        double[] voiceds = new double[numHarmonics];
        double[] vals1 = new double[numHarmonics];
        double[] vals2 = new double[numHarmonics];
        double[] vals3 = new double[numHarmonics];
        Arrays.fill(vals1, Double.NEGATIVE_INFINITY);
        Arrays.fill(vals2, Double.NEGATIVE_INFINITY);
        Arrays.fill(vals3, Double.NEGATIVE_INFINITY);
        Arrays.fill(voiceds, 0.0);
        int[] valleyInds = MathUtils.getExtrema(absDBSpec, 2, 2, false);
        int[] tmpPeakIndices = new int[numHarmonics];
        for (i = 0; i < numHarmonics; ++i) {
            int n;
            int fcIndex;
            int[] fcIndices;
            int neigh = (int)Math.floor((double)params.neighsPercent / 100.0 * 0.5 * (double)(bandInds[i + 1] - bandInds[i]) + 0.5);
            if (neigh < 1) {
                neigh = 1;
            }
            if ((fcIndices = MathUtils.getExtrema(absDBSpec, 1, 1, true, bandInds[i], bandInds[i + 1])) != null) {
                fcIndex = fcIndices[0];
                double bandExtremaVal = absDBSpec[fcIndex];
                for (n = 1; n < fcIndices.length; ++n) {
                    if (!(absDBSpec[fcIndices[n]] > bandExtremaVal)) continue;
                    fcIndex = fcIndices[n];
                    bandExtremaVal = absDBSpec[fcIndex];
                }
            } else {
                fcIndex = MathUtils.getAbsMaxInd(absDBSpec, bandInds[i], bandInds[i + 1]);
                if (fcIndex == -1) {
                    fcIndex = (int)Math.floor(0.5 * (double)(bandInds[i] + bandInds[i + 1]) + 0.5);
                }
            }
            double fc = SignalProcUtils.index2freq(fcIndex, samplingRate, maxFreqIndex);
            double Am = absDBSpec[fcIndex];
            double Amc = HnmPitchVoicingAnalyzer.computeAmc(absDBSpec, fcIndex, valleyInds);
            int startInd = SignalProcUtils.freq2index(fc - 0.5 * (double)f0, (double)samplingRate, maxFreqIndex);
            int endInd = SignalProcUtils.freq2index(fc + 0.5 * (double)f0, (double)samplingRate, maxFreqIndex);
            int[] peakInds = MathUtils.getExtrema(absDBSpec, 1, 1, true, startInd, endInd);
            double[] Ams = null;
            double[] Amcs = null;
            voiceds[i] = 0.0;
            if (peakInds != null) {
                if (peakInds.length > 1) {
                    int total = 0;
                    for (n = 0; n < peakInds.length; ++n) {
                        if (peakInds[n] == fcIndex) continue;
                        ++total;
                    }
                    Ams = new double[total];
                    Amcs = new double[total];
                    int counter = 0;
                    for (n = 0; n < peakInds.length; ++n) {
                        if (peakInds[n] == fcIndex) continue;
                        Ams[counter] = absDBSpec[peakInds[n]];
                        Amcs[counter] = HnmPitchVoicingAnalyzer.computeAmc(absDBSpec, peakInds[n], valleyInds);
                        ++counter;
                    }
                } else {
                    double bandMinVal = absDBSpec[MathUtils.getMinIndex(absDBSpec, startInd, endInd)];
                    if (Am - bandMinVal > (double)params.sharpPeakAmpDiffInDB) {
                        voiceds[i] = 1.0;
                    }
                }
            }
            if (voiceds[i] != 1.0 && Amcs != null) {
                double meanAmcs = MathUtils.mean(Amcs);
                vals1[i] = Amc / meanAmcs;
                vals3[i] = Math.abs(fc - (double)(i + 1) * (double)f0) / ((double)(i + 1) * (double)f0);
                if (vals1[i] > (double)params.cumulativeAmpThreshold && vals3[i] < (double)params.harmonicDeviationPercent / 100.0) {
                    voiceds[i] = 1.0;
                }
            }
            if (voiceds[i] != 1.0 && Ams != null) {
                double maxAms = MathUtils.max(Ams);
                vals2[i] = Am - maxAms;
                vals3[i] = Math.abs(fc - (double)(i + 1) * (double)f0) / ((double)(i + 1) * (double)f0);
                if (vals2[i] > (double)params.maximumAmpThresholdInDB && vals3[i] < (double)params.harmonicDeviationPercent / 100.0) {
                    voiceds[i] = 1.0;
                }
            }
            tmpPeakIndices[i] = fcIndex;
        }
        double[] runningMeans = new double[voiceds.length];
        for (i = 0; i < voiceds.length; ++i) {
            runningMeans[i] = MathUtils.mean(voiceds, 0, i);
        }
        int numPoints = 3;
        runningMeans = SignalProcUtils.meanFilter(runningMeans, numPoints);
        int maxVoicedHarmonicBand = -1;
        for (i = 0; !(i >= runningMeans.length - 2 || runningMeans[i] < (double)params.runningMeanVoicingThreshold && runningMeans[i + 1] < (double)params.runningMeanVoicingThreshold && runningMeans[i + 1] < (double)params.runningMeanVoicingThreshold); ++i) {
            maxVoicedHarmonicBand = i + 2;
        }
        output.maxFreqOfVoicing = maxVoicedHarmonicBand > -1 ? (float)Math.min(((double)maxVoicedHarmonicBand + 0.5) * (double)f0 + 0.5 * (double)numPoints * (double)f0, 0.5 * (double)samplingRate) : 0.0f;
        output.maxFreqOfVoicing = MathUtils.CheckLimits(output.maxFreqOfVoicing, 0.0f, 0.5f * (float)samplingRate);
        if (output.maxFreqOfVoicing > 0.0f) {
            int count = (int)Math.floor((double)(output.maxFreqOfVoicing / f0) + 0.5);
            if ((count = MathUtils.CheckLimits(count, 0, numHarmonics)) > 0) {
                output.peakIndices = new int[count];
                System.arraycopy(tmpPeakIndices, 0, output.peakIndices, 0, count);
            }
        }
        if (!isSilentAnalysis) {
            System.out.println("Max freq of voicing=" + String.valueOf(output.maxFreqOfVoicing));
        }
        if (prevMaxFreqVoicing > -1.0f) {
            output.maxFreqOfVoicing = prevPrevMaxFreqVoicing > -1.0f ? 0.45f * output.maxFreqOfVoicing + 0.35f * prevMaxFreqVoicing + 0.2f * prevPrevMaxFreqVoicing : 0.6f * output.maxFreqOfVoicing + 0.4f * prevMaxFreqVoicing;
        }
        return output;
    }

    private static double computeAmc(double[] spec, int fcIndex, int[] valleyInds) {
        double Amc = spec[fcIndex];
        if (valleyInds != null) {
            int vLeftInd = -1;
            int vRightInd = -1;
            int counter = 0;
            vLeftInd = 0;
            while (fcIndex > valleyInds[counter]) {
                vLeftInd = valleyInds[counter];
                if (counter == valleyInds.length - 1) break;
                ++counter;
            }
            counter = valleyInds.length - 1;
            vRightInd = spec.length - 1;
            while (valleyInds[counter] > fcIndex) {
                vRightInd = valleyInds[counter];
                if (counter == 0) break;
                --counter;
            }
            for (int i = vLeftInd; i <= vRightInd; ++i) {
                if (i == fcIndex) continue;
                Amc += spec[i];
            }
        }
        return Amc;
    }

    public static double estimateVoicingFromFrameSpectrum(double[] absSpec, int samplingRate, float f0, double vuvSearchMinHarmonicMultiplier, double vuvSearchMaxHarmonicMultiplier) {
        int j;
        int i;
        boolean isVoiced = false;
        int maxFreq = absSpec.length;
        int minFreqInd = SignalProcUtils.freq2index(vuvSearchMinHarmonicMultiplier * (double)f0, (double)samplingRate, maxFreq - 1);
        int maxFreqInd = SignalProcUtils.freq2index(vuvSearchMaxHarmonicMultiplier * (double)f0, (double)samplingRate, maxFreq - 1);
        int harmonicNoFirst = (int)Math.floor(vuvSearchMinHarmonicMultiplier) + 1;
        int harmonicNoLast = (int)Math.floor(vuvSearchMaxHarmonicMultiplier);
        int numHarmonicsInRange = harmonicNoLast - harmonicNoFirst + 1;
        int[] harmonicsInds = new int[numHarmonicsInRange];
        for (i = harmonicNoFirst; i <= harmonicNoLast; ++i) {
            harmonicsInds[i - harmonicNoFirst] = SignalProcUtils.freq2index((float)i * f0, (double)samplingRate, maxFreq - 1);
        }
        double num = 0.0;
        double denum = 0.0;
        for (j = minFreqInd; j < harmonicsInds[0] - 2; ++j) {
            num += absSpec[j] * absSpec[j];
        }
        for (i = 0; i < numHarmonicsInRange - 1; ++i) {
            for (j = harmonicsInds[i] + 1 + 2; j < harmonicsInds[i + 1] - 2; ++j) {
                num += absSpec[j] * absSpec[j];
            }
        }
        for (j = harmonicsInds[numHarmonicsInRange - 1] + 1 + 2; j <= maxFreqInd; ++j) {
            num += absSpec[j] * absSpec[j];
        }
        for (j = minFreqInd; j <= maxFreqInd; ++j) {
            denum += absSpec[j] * absSpec[j];
        }
        double E = num / denum;
        E = MathUtils.db(E);
        return E;
    }

    public static float[] estimateRefinedPitch(int fftSize, int samplingRateInHz, float leftNeighInHz, float rightNeighInHz, float searchStepInHz, float[] initialF0s, float[] maxFrequencyOfVoicings) {
        float[] f0s = new float[initialF0s.length];
        for (int i = 0; i < initialF0s.length; ++i) {
            f0s[i] = HnmPitchVoicingAnalyzer.estimateRefinedFramePitch(initialF0s[i], maxFrequencyOfVoicings[i], fftSize, samplingRateInHz, leftNeighInHz, rightNeighInHz, searchStepInHz);
        }
        return f0s;
    }

    public static float estimateRefinedFramePitch(float f0InHz, float maxFreqOfVoicingInHz, int fftSize, int samplingRateInHz, float leftNeighInHz, float rightNeighInHz, float searchStepInHz) {
        int i;
        float refinedF0InHz = 0.0f;
        int maxFreqIndex = fftSize / 2 + 1;
        int maxVoicedFreqInd = SignalProcUtils.freq2index(maxFreqOfVoicingInHz, (double)samplingRateInHz, maxFreqIndex);
        float[] freqIndsInHz = new float[maxVoicedFreqInd];
        for (i = 0; i < maxVoicedFreqInd; ++i) {
            freqIndsInHz[i] = (float)SignalProcUtils.index2freq(i, samplingRateInHz, maxFreqIndex - 1);
        }
        double Emin = Double.MAX_VALUE;
        refinedF0InHz = f0InHz;
        for (float f0New = f0InHz - leftNeighInHz; f0New <= f0InHz + rightNeighInHz; f0New += searchStepInHz) {
            double E = 0.0;
            for (i = 0; i < maxVoicedFreqInd; ++i) {
                E += (double)Math.abs(freqIndsInHz[i] - (float)i * f0New);
            }
            if (!(E < Emin)) continue;
            Emin = E;
            refinedF0InHz = f0New;
        }
        return refinedF0InHz;
    }

    public static void main(String[] args) throws UnsupportedAudioFileException, IOException {
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[0]));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] x = signal.getAllData();
        HnmPitchVoicingAnalyzerParams params = new HnmPitchVoicingAnalyzerParams();
        params.mvfAnalysisWindowSizeInSeconds = 0.04f;
        params.mvfAnalysisSkipSizeInSeconds = 0.01f;
        int windowType = 2;
        float f0MinInHz = 60.0f;
        float f0MaxInHz = 500.0f;
        float leftNeighInHz = 20.0f;
        float rightNeighInHz = 20.0f;
        float searchStepInHz = 0.01f;
        params.fftSize = HnmPitchVoicingAnalyzer.getDefaultFFTSize(samplingRate);
        float[] initialF0s = HnmPitchVoicingAnalyzer.estimateInitialPitch(x, samplingRate, f0MinInHz, f0MaxInHz, windowType, params);
        float[] maxFrequencyOfVoicings = HnmPitchVoicingAnalyzer.analyzeVoicings(x, samplingRate, initialF0s, params, false);
        float[] f0s = HnmPitchVoicingAnalyzer.estimateRefinedPitch(params.fftSize, samplingRate, leftNeighInHz, rightNeighInHz, searchStepInHz, initialF0s, maxFrequencyOfVoicings);
        for (int i = 0; i < f0s.length; ++i) {
            System.out.println(String.valueOf((float)i * params.mvfAnalysisSkipSizeInSeconds + 0.5f * params.mvfAnalysisWindowSizeInSeconds) + " sec. InitialF0=" + String.valueOf(initialF0s[i]) + " RefinedF0=" + String.valueOf(f0s[i]));
        }
        DisplayUtils.plot(initialF0s);
        DisplayUtils.plot(f0s);
    }
}

