/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.ForwardBackwardCalculator;
import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardBackwardScaledCalculator
extends ForwardBackwardCalculator {
    private double[] ctFactors;
    private double lnProbability;

    public <O extends Observation> ForwardBackwardScaledCalculator(List<? extends O> oseq, Hmm<O> hmm, EnumSet<ForwardBackwardCalculator.Computation> flags) {
        if (oseq.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.ctFactors = new double[oseq.size()];
        Arrays.fill(this.ctFactors, 0.0);
        this.computeAlpha(hmm, oseq);
        if (flags.contains((Object)ForwardBackwardCalculator.Computation.BETA)) {
            this.computeBeta(hmm, oseq);
        }
        this.computeProbability(oseq, hmm, flags);
    }

    public <O extends Observation> ForwardBackwardScaledCalculator(List<? extends O> oseq, Hmm<O> hmm) {
        this(oseq, hmm, EnumSet.of(ForwardBackwardCalculator.Computation.ALPHA));
    }

    @Override
    protected <O extends Observation> void computeAlpha(Hmm<? super O> hmm, List<O> oseq) {
        this.alpha = new double[oseq.size()][hmm.nbStates()];
        int i = 0;
        while (i < hmm.nbStates()) {
            this.computeAlphaInit(hmm, (Observation)oseq.get(0), i);
            ++i;
        }
        this.scale(this.ctFactors, this.alpha, 0);
        Iterator<O> seqIterator = oseq.iterator();
        if (seqIterator.hasNext()) {
            seqIterator.next();
        }
        int t = 1;
        while (t < oseq.size()) {
            Observation observation = (Observation)seqIterator.next();
            int i2 = 0;
            while (i2 < hmm.nbStates()) {
                this.computeAlphaStep(hmm, observation, t, i2);
                ++i2;
            }
            this.scale(this.ctFactors, this.alpha, t);
            ++t;
        }
    }

    @Override
    protected <O extends Observation> void computeBeta(Hmm<? super O> hmm, List<O> oseq) {
        this.beta = new double[oseq.size()][hmm.nbStates()];
        int i = 0;
        while (i < hmm.nbStates()) {
            this.beta[oseq.size() - 1][i] = 1.0 / this.ctFactors[oseq.size() - 1];
            ++i;
        }
        int t = oseq.size() - 2;
        while (t >= 0) {
            int i2 = 0;
            while (i2 < hmm.nbStates()) {
                this.computeBetaStep(hmm, (Observation)oseq.get(t + 1), t, i2);
                double[] dArray = this.beta[t];
                int n = i2++;
                dArray[n] = dArray[n] / this.ctFactors[t];
            }
            --t;
        }
    }

    private void scale(double[] ctFactors, double[][] array, int t) {
        double[] table = array[t];
        double sum = 0.0;
        int i = 0;
        while (i < table.length) {
            sum += table[i];
            ++i;
        }
        ctFactors[t] = sum;
        i = 0;
        while (i < table.length) {
            int n = i++;
            table[n] = table[n] / sum;
        }
    }

    private <O extends Observation> void computeProbability(List<O> oseq, Hmm<? super O> hmm, EnumSet<ForwardBackwardCalculator.Computation> flags) {
        this.lnProbability = 0.0;
        int t = 0;
        while (t < oseq.size()) {
            this.lnProbability += Math.log(this.ctFactors[t]);
            ++t;
        }
        this.probability = Math.exp(this.lnProbability);
    }

    public double lnProbability() {
        return this.lnProbability;
    }
}

