/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.io;

import be.ac.ulg.montefiore.run.jahmm.ObservationVector;
import be.ac.ulg.montefiore.run.jahmm.io.FileFormatException;
import be.ac.ulg.montefiore.run.jahmm.io.ObservationReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservationVectorReader
extends ObservationReader<ObservationVector> {
    private int dimension;

    public ObservationVectorReader() {
        this.dimension = -1;
    }

    public ObservationVectorReader(int dimension) {
        if (dimension <= 0) {
            throw new IllegalArgumentException("Argument must be strictly positive");
        }
        this.dimension = dimension;
    }

    @Override
    public ObservationVector read(StreamTokenizer st) throws IOException, FileFormatException {
        if (st.nextToken() != 91) {
            throw new FileFormatException(st.lineno(), "'[' expected");
        }
        ArrayList<Double> values = new ArrayList<Double>();
        block4: while (true) {
            switch (st.nextToken()) {
                case -2: {
                    values.add(new Double(st.nval));
                    break;
                }
                case 93: {
                    if (values.size() != 0) break block4;
                    throw new FileFormatException(st.lineno(), "Empty vector found");
                }
                default: {
                    throw new FileFormatException(st.lineno(), "Number or ']' expected");
                }
            }
        }
        if (st.nextToken() != 59) {
            throw new FileFormatException(st.lineno(), "';' expected");
        }
        if (this.dimension > 0 && values.size() != this.dimension) {
            throw new FileFormatException(st.lineno(), "Bad observation: wrong dimension (" + values.size() + " instead of " + this.dimension + ")");
        }
        double[] valuesArray = new double[values.size()];
        int i = 0;
        while (i < values.size()) {
            valuesArray[i] = (Double)values.get(i);
            ++i;
        }
        return new ObservationVector(valuesArray);
    }
}

