/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.learn;

import be.ac.ulg.montefiore.run.jahmm.CentroidFactory;
import be.ac.ulg.montefiore.run.jahmm.KMeansCalculator;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Clusters<O extends CentroidFactory<? super O>> {
    private Hashtable<O, Value> clustersHash = new Hashtable();
    private ArrayList<Collection<O>> clusters = new ArrayList();

    public Clusters(int k, List<? extends O> observations) {
        KMeansCalculator<O> kmc = new KMeansCalculator<O>(k, observations);
        int i = 0;
        while (i < k) {
            Collection<O> cluster = kmc.cluster(i);
            this.clusters.add(cluster);
            for (CentroidFactory element : cluster) {
                this.clustersHash.put(element, new Value(i));
            }
            ++i;
        }
    }

    public boolean isInCluster(Observation o, int clusterNb) {
        return this.clusterNb(o) == clusterNb;
    }

    public int clusterNb(Observation o) {
        return this.clustersHash.get(o).getClusterNb();
    }

    public Collection<O> cluster(int clusterNb) {
        return this.clusters.get(clusterNb);
    }

    public void remove(Observation o, int clusterNb) {
        this.clustersHash.get(o).setClusterNb(-1);
        this.clusters.get(clusterNb).remove(o);
    }

    public void put(O o, int clusterNb) {
        this.clustersHash.get(o).setClusterNb(clusterNb);
        this.clusters.get(clusterNb).add(o);
    }

    class Value {
        private int clusterNb;

        Value(int clusterNb) {
            this.clusterNb = clusterNb;
        }

        void setClusterNb(int clusterNb) {
            this.clusterNb = clusterNb;
        }

        int getClusterNb() {
            return this.clusterNb;
        }
    }
}

