/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.test;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.ObservationInteger;
import be.ac.ulg.montefiore.run.jahmm.OpdfIntegerFactory;
import be.ac.ulg.montefiore.run.jahmm.learn.BaumWelchLearner;
import be.ac.ulg.montefiore.run.jahmm.learn.BaumWelchScaledLearner;
import be.ac.ulg.montefiore.run.jahmm.learn.KMeansLearner;
import be.ac.ulg.montefiore.run.jahmm.toolbox.KullbackLeiblerDistanceCalculator;
import be.ac.ulg.montefiore.run.jahmm.toolbox.MarkovGenerator;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class LearnerTest
extends TestCase {
    private static final double DELTA = 0.005;
    private Hmm<ObservationInteger> hmm;
    private List<List<ObservationInteger>> sequences;
    private KullbackLeiblerDistanceCalculator klc;

    protected void setUp() {
        this.hmm = new Hmm(3, new OpdfIntegerFactory(10));
        this.hmm.getOpdf(0).fit(new ObservationInteger[]{new ObservationInteger(1), new ObservationInteger(2)});
        MarkovGenerator<ObservationInteger> mg = new MarkovGenerator<ObservationInteger>(this.hmm);
        this.sequences = new ArrayList<List<ObservationInteger>>();
        int i = 0;
        while (i < 100) {
            this.sequences.add(mg.observationSequence(100));
            ++i;
        }
        this.klc = new KullbackLeiblerDistanceCalculator();
    }

    public void testBaumWelch() {
        BaumWelchLearner bwl = new BaumWelchLearner();
        Hmm<ObservationInteger> bwHmm = bwl.learn(this.hmm, this.sequences);
        LearnerTest.assertEquals((double)0.0, (double)this.klc.distance(bwHmm, this.hmm), (double)0.005);
        BaumWelchScaledLearner bwsl = new BaumWelchScaledLearner();
        bwHmm = bwsl.learn(this.hmm, this.sequences);
        LearnerTest.assertEquals((double)0.0, (double)this.klc.distance(bwHmm, this.hmm), (double)0.005);
    }

    public void testKMeans() {
        KMeansLearner<ObservationInteger> kml = new KMeansLearner<ObservationInteger>(5, new OpdfIntegerFactory(10), this.sequences);
        LearnerTest.assertEquals((double)0.0, (double)this.klc.distance(kml.learn(), this.hmm), (double)0.005);
    }
}

