/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.test;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.ObservationDiscrete;
import be.ac.ulg.montefiore.run.jahmm.OpdfDiscrete;
import be.ac.ulg.montefiore.run.jahmm.OpdfDiscreteFactory;
import be.ac.ulg.montefiore.run.jahmm.draw.GenericHmmDrawerDot;
import be.ac.ulg.montefiore.run.jahmm.learn.BaumWelchLearner;
import be.ac.ulg.montefiore.run.jahmm.toolbox.KullbackLeiblerDistanceCalculator;
import be.ac.ulg.montefiore.run.jahmm.toolbox.MarkovGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleExample {
    public static void main(String[] argv) throws IOException {
        Hmm<ObservationDiscrete<Packet>> hmm = SimpleExample.buildHmm();
        List<List<ObservationDiscrete<Packet>>> sequences = SimpleExample.generateSequences(hmm);
        BaumWelchLearner bwl = new BaumWelchLearner();
        Hmm<ObservationDiscrete<Packet>> learntHmm = SimpleExample.buildInitHmm();
        KullbackLeiblerDistanceCalculator klc = new KullbackLeiblerDistanceCalculator();
        int i = 0;
        while (i < 10) {
            System.out.println("Distance at iteration " + i + ": " + klc.distance(learntHmm, hmm));
            learntHmm = bwl.iterate(learntHmm, sequences);
            ++i;
        }
        System.out.println("Resulting HMM:\n" + learntHmm);
        ObservationDiscrete<Packet> packetOk = Packet.OK.observation();
        ObservationDiscrete<Packet> packetLoss = Packet.LOSS.observation();
        ArrayList<ObservationDiscrete<Packet>> testSequence = new ArrayList<ObservationDiscrete<Packet>>();
        testSequence.add(packetOk);
        testSequence.add(packetOk);
        testSequence.add(packetLoss);
        System.out.println("Sequence probability: " + learntHmm.probability(testSequence));
        new GenericHmmDrawerDot().write(learntHmm, "learntHmm.dot");
    }

    static Hmm<ObservationDiscrete<Packet>> buildHmm() {
        Hmm<ObservationDiscrete<Packet>> hmm = new Hmm<ObservationDiscrete<Packet>>(2, new OpdfDiscreteFactory<Packet>(Packet.class));
        hmm.setPi(0, 0.95);
        hmm.setPi(1, 0.05);
        hmm.setOpdf(0, new OpdfDiscrete<Packet>(Packet.class, new double[]{0.95, 0.05}));
        hmm.setOpdf(1, new OpdfDiscrete<Packet>(Packet.class, new double[]{0.2, 0.8}));
        hmm.setAij(0, 1, 0.05);
        hmm.setAij(0, 0, 0.95);
        hmm.setAij(1, 0, 0.1);
        hmm.setAij(1, 1, 0.9);
        return hmm;
    }

    static Hmm<ObservationDiscrete<Packet>> buildInitHmm() {
        Hmm<ObservationDiscrete<Packet>> hmm = new Hmm<ObservationDiscrete<Packet>>(2, new OpdfDiscreteFactory<Packet>(Packet.class));
        hmm.setPi(0, 0.5);
        hmm.setPi(1, 0.5);
        hmm.setOpdf(0, new OpdfDiscrete<Packet>(Packet.class, new double[]{0.8, 0.2}));
        hmm.setOpdf(1, new OpdfDiscrete<Packet>(Packet.class, new double[]{0.1, 0.9}));
        hmm.setAij(0, 1, 0.2);
        hmm.setAij(0, 0, 0.8);
        hmm.setAij(1, 0, 0.2);
        hmm.setAij(1, 1, 0.8);
        return hmm;
    }

    static <O extends Observation> List<List<O>> generateSequences(Hmm<O> hmm) {
        MarkovGenerator<O> mg = new MarkovGenerator<O>(hmm);
        ArrayList<List<O>> sequences = new ArrayList<List<O>>();
        int i = 0;
        while (i < 200) {
            sequences.add(mg.observationSequence(100));
            ++i;
        }
        return sequences;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Packet {
        OK,
        LOSS;


        public ObservationDiscrete<Packet> observation() {
            return new ObservationDiscrete<Packet>(this);
        }
    }
}

