/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Statistics;
import com.rapidminer.tools.LogService;

public class MinMaxStatistics
implements Statistics {
    private static final long serialVersionUID = 1027895282018510951L;
    private double minimum = Double.POSITIVE_INFINITY;
    private double maximum = Double.NEGATIVE_INFINITY;

    public MinMaxStatistics() {
    }

    private MinMaxStatistics(MinMaxStatistics other) {
        this.minimum = other.minimum;
        this.maximum = other.maximum;
    }

    public Object clone() {
        return new MinMaxStatistics(this);
    }

    public void count(double value, double weight) {
        if (!Double.isNaN(value)) {
            if (this.minimum > value) {
                this.minimum = value;
            }
            if (this.maximum < value) {
                this.maximum = value;
            }
        }
    }

    public double getStatistics(Attribute attribute, String name, String parameter) {
        if ("minimum".equals(name)) {
            return this.minimum;
        }
        if ("maximum".equals(name)) {
            return this.maximum;
        }
        LogService.getGlobal().log("Cannot calculate statistics, unknown type: " + name, 5);
        return Double.NaN;
    }

    public boolean handleStatistics(String name) {
        return "minimum".equals(name) || "maximum".equals(name);
    }

    public void startCounting(Attribute attribute) {
        this.minimum = Double.POSITIVE_INFINITY;
        this.maximum = Double.NEGATIVE_INFINITY;
    }
}

