/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.MinMaxStatistics;
import com.rapidminer.example.NominalStatistics;
import com.rapidminer.example.NumericalStatistics;
import com.rapidminer.example.UnknownStatistics;
import com.rapidminer.example.WeightedNumericalStatistics;
import com.rapidminer.example.table.AbstractAttribute;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.operator.ViewModel;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.Tools;

public class ViewAttribute
extends AbstractAttribute {
    private static final long serialVersionUID = -4075558616549596028L;
    private NominalMapping mapping;
    private boolean isNominal;
    private boolean isNumerical;
    private ViewModel model;
    private Attribute parent;

    ViewAttribute(ViewAttribute other) {
        super(other);
        if (other.mapping != null) {
            this.mapping = (NominalMapping)other.mapping.clone();
        }
        this.isNominal = other.isNominal;
        this.isNumerical = other.isNumerical;
        this.model = other.model;
        if (other.parent != null) {
            this.parent = (Attribute)other.parent.clone();
        }
    }

    public ViewAttribute(ViewModel model, Attribute parent, String name, int valueType, NominalMapping mapping) {
        super(name, valueType);
        this.model = model;
        this.mapping = mapping;
        this.isNominal = mapping != null && Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 1);
        this.isNumerical = Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 2);
        this.parent = parent;
        if (this.isNominal) {
            this.registerStatistics(new NominalStatistics());
            this.registerStatistics(new UnknownStatistics());
        } else {
            this.registerStatistics(new NumericalStatistics());
            this.registerStatistics(new WeightedNumericalStatistics());
            this.registerStatistics(new MinMaxStatistics());
            this.registerStatistics(new UnknownStatistics());
        }
    }

    public double getValue(DataRow row) {
        return this.model.getValue(this, row.get(this.parent));
    }

    public Object clone() {
        return new ViewAttribute(this);
    }

    public String getAsString(double value, int numberOfDigits, boolean quoteNominal) {
        if (this.isNominal) {
            if (Double.isNaN(value)) {
                return "?";
            }
            try {
                String result = this.mapping.mapIndex((int)value);
                if (quoteNominal) {
                    result = result.replaceAll("\"", "\\\\\"");
                    result = "\"" + result + "\"";
                }
                return result;
            }
            catch (Throwable e) {
                return "?";
            }
        }
        if (Double.isNaN(value)) {
            return "?";
        }
        switch (numberOfDigits) {
            case -2: {
                return Double.toString(value);
            }
            case -1: {
                return Tools.formatIntegerIfPossible(value, -1);
            }
        }
        return Tools.formatIntegerIfPossible(value, numberOfDigits);
    }

    public NominalMapping getMapping() {
        return this.mapping;
    }

    public boolean isNominal() {
        return this.isNominal;
    }

    public boolean isNumerical() {
        return this.isNumerical;
    }

    public void setMapping(NominalMapping nominalMapping) {
        this.mapping = nominalMapping;
    }

    public int getTableIndex() {
        return this.parent.getTableIndex();
    }
}

