/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.charts.ChartPanelShiftController;
import com.rapidminer.gui.plotter.charts.CtrlChartPanel;
import com.rapidminer.gui.plotter.charts.WeightBasedSymbolAxis;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.MathFunctions;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviationChartPlotter
extends PlotterAdapter {
    private static final long serialVersionUID = -8763693366081949249L;
    private transient DataTable dataTable;
    private YIntervalSeriesCollection dataset = null;
    private int colorColumn = -1;
    private String[] domainAxisMap = null;
    private JCheckBox localNormalizationBox;
    private boolean localNormalization = false;
    private JCheckBox rotateLabels = new JCheckBox("Rotate Labels", false);
    private ChartPanel panel = new ChartPanel(null);

    public DeviationChartPlotter() {
        this.setBackground(Color.white);
        this.localNormalizationBox = new JCheckBox("Local Normalization", this.localNormalization);
        this.localNormalizationBox.setToolTipText("Indicates if a local normalization for each dimension should be performed or not.");
        this.localNormalizationBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DeviationChartPlotter.this.setLocalNormalization(DeviationChartPlotter.this.localNormalizationBox.isSelected());
            }
        });
        this.rotateLabels.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeviationChartPlotter.this.updatePlotter();
            }
        });
    }

    public DeviationChartPlotter(DataTable dataTable) {
        this();
        this.setDataTable(dataTable);
    }

    @Override
    public JComponent getPlotter() {
        return this.panel;
    }

    private JFreeChart createChart(XYDataset dataset, boolean createLegend) {
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)createLegend, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        DeviationRenderer renderer = new DeviationRenderer(true, false);
        BasicStroke stroke = new BasicStroke(2.0f, 1, 1);
        if (dataset.getSeriesCount() == 1) {
            renderer.setSeriesStroke(0, (Stroke)stroke);
            renderer.setSeriesPaint(0, (Paint)Color.RED);
            renderer.setSeriesFillPaint(0, (Paint)Color.RED);
        } else {
            int i = 0;
            while (i < dataset.getSeriesCount()) {
                renderer.setSeriesStroke(i, (Stroke)stroke);
                Color color = this.getColorProvider().getPointColor((double)i / (double)(dataset.getSeriesCount() - 1));
                renderer.setSeriesPaint(i, (Paint)color);
                renderer.setSeriesFillPaint(i, (Paint)color);
                ++i;
            }
        }
        renderer.setAlpha(0.12f);
        plot.setRenderer((XYItemRenderer)renderer);
        ValueAxis valueAxis = plot.getRangeAxis();
        valueAxis.setLabelFont(LABEL_FONT_BOLD);
        valueAxis.setTickLabelFont(LABEL_FONT);
        return chart;
    }

    @Override
    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.updatePlotter();
    }

    public void setLocalNormalization(boolean localNormalization) {
        this.localNormalization = localNormalization;
        this.updatePlotter();
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.colorColumn = plot ? index : -1;
        this.updatePlotter();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.colorColumn == index;
    }

    @Override
    public String getPlotName() {
        return "Color Column";
    }

    @Override
    public int getNumberOfAxes() {
        return 0;
    }

    public void setRotateLabels(boolean rotateLabels) {
        this.rotateLabels.setSelected(rotateLabels);
        this.updatePlotter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int prepareData() {
        int columns = this.dataTable.getNumberOfColumns();
        double[] min = new double[columns];
        double[] max = new double[columns];
        int c = 0;
        while (c < columns) {
            min[c] = Double.POSITIVE_INFINITY;
            max[c] = Double.NEGATIVE_INFINITY;
            ++c;
        }
        DataTable dataTable = this.dataTable;
        synchronized (dataTable) {
            for (DataTableRow row : this.dataTable) {
                int c2 = 0;
                while (c2 < this.dataTable.getNumberOfColumns()) {
                    double value = row.getValue(c2);
                    min[c2] = MathFunctions.robustMin(min[c2], value);
                    max[c2] = MathFunctions.robustMax(max[c2], value);
                    ++c2;
                }
            }
        }
        dataTable = this.dataTable;
        synchronized (dataTable) {
            this.dataset = new YIntervalSeriesCollection();
            if (this.colorColumn >= 0 && this.dataTable.isNominal(this.colorColumn)) {
                int v = 0;
                while (v < this.dataTable.getNumberOfValues(this.colorColumn)) {
                    String valueName = this.dataTable.mapIndex(this.colorColumn, v);
                    YIntervalSeries series = new YIntervalSeries((Comparable)((Object)valueName));
                    boolean first = true;
                    LinkedList<String> domainValues = new LinkedList<String>();
                    int column = 0;
                    while (column < this.dataTable.getNumberOfColumns()) {
                        if (!this.dataTable.isSpecial(column) && column != this.colorColumn) {
                            Iterator<DataTableRow> i = this.dataTable.iterator();
                            double sum = 0.0;
                            double squaredSum = 0.0;
                            int counter = 0;
                            while (i.hasNext()) {
                                DataTableRow row = i.next();
                                if (row.getValue(this.colorColumn) != (double)v) continue;
                                double value = row.getValue(column);
                                sum += value;
                                squaredSum += value * value;
                                ++counter;
                            }
                            double mean = sum / (double)counter;
                            double deviation = Math.sqrt(squaredSum / (double)counter - mean * mean);
                            if (this.localNormalization) {
                                mean = (mean - min[column]) / (max[column] - min[column]);
                                deviation = (deviation - min[column]) / (max[column] - min[column]);
                            }
                            series.add((double)column, mean, mean - deviation, mean + deviation);
                            domainValues.add(this.dataTable.getColumnName(column));
                        }
                        ++column;
                    }
                    if (first) {
                        this.domainAxisMap = new String[domainValues.size()];
                        domainValues.toArray(this.domainAxisMap);
                    }
                    first = false;
                    this.dataset.addSeries(series);
                    ++v;
                }
                return this.dataTable.getNumberOfValues(this.colorColumn);
            }
            YIntervalSeries series = new YIntervalSeries((Comparable)((Object)this.dataTable.getName()));
            LinkedList<String> domainValues = new LinkedList<String>();
            int column = 0;
            while (column < this.dataTable.getNumberOfColumns()) {
                if (!this.dataTable.isSpecial(column) && column != this.colorColumn) {
                    Iterator<DataTableRow> i = this.dataTable.iterator();
                    double sum = 0.0;
                    double squaredSum = 0.0;
                    int counter = 0;
                    while (i.hasNext()) {
                        DataTableRow row = i.next();
                        double value = row.getValue(column);
                        sum += value;
                        squaredSum += value * value;
                        ++counter;
                    }
                    double mean = sum / (double)counter;
                    double deviation = Math.sqrt(squaredSum / (double)counter - mean * mean);
                    if (this.localNormalization) {
                        mean = (mean - min[column]) / (max[column] - min[column]);
                    }
                    series.add((double)column, mean, mean - deviation, mean + deviation);
                    domainValues.add(this.dataTable.getColumnName(column));
                }
                ++column;
            }
            this.dataset.addSeries(series);
            this.domainAxisMap = new String[domainValues.size()];
            domainValues.toArray(this.domainAxisMap);
            return 0;
        }
    }

    public void updatePlotter() {
        int categoryCount = this.prepareData();
        String maxClassesProperty = System.getProperty("rapidminer.gui.plotter.colors.classlimit");
        int maxClasses = 20;
        try {
            if (maxClassesProperty != null) {
                maxClasses = Integer.parseInt(maxClassesProperty);
            }
        }
        catch (NumberFormatException e) {
            LogService.getGlobal().log("Deviation plotter: cannot parse property 'rapidminer.gui.plotter.colors.classlimit', using maximal 20 different classes.", 5);
        }
        boolean createLegend = categoryCount > 0 && categoryCount < maxClasses;
        JFreeChart chart = this.createChart((XYDataset)this.dataset, createLegend);
        chart.setBackgroundPaint((Paint)Color.white);
        SymbolAxis axis = null;
        if (this.dataTable.isSupportingColumnWeights()) {
            LinkedList<Double> weightList = new LinkedList<Double>();
            int column = 0;
            while (column < this.dataTable.getNumberOfColumns()) {
                if (!this.dataTable.isSpecial(column) && column != this.colorColumn) {
                    weightList.add(this.dataTable.getColumnWeight(column));
                }
                ++column;
            }
            double[] weights = new double[weightList.size()];
            int index = 0;
            for (Double d : weightList) {
                weights[index++] = d;
            }
            axis = new WeightBasedSymbolAxis(null, this.domainAxisMap, weights);
        } else {
            axis = new SymbolAxis(null, this.domainAxisMap);
        }
        axis.setTickLabelFont(LABEL_FONT);
        axis.setLabelFont(LABEL_FONT_BOLD);
        if (this.rotateLabels.isSelected()) {
            axis.setTickLabelsVisible(true);
            axis.setVerticalTickLabels(true);
        }
        chart.getXYPlot().setDomainAxis((ValueAxis)axis);
        LegendTitle legend = chart.getLegend();
        if (legend != null) {
            legend.setPosition(RectangleEdge.TOP);
            legend.setFrame((BlockFrame)BlockBorder.NONE);
            legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
            legend.setItemFont(LABEL_FONT);
        }
        if (this.panel instanceof CtrlChartPanel) {
            this.panel.setChart(chart);
        } else {
            this.panel = new CtrlChartPanel(chart, this.getWidth(), this.getHeight() - 20);
            ChartPanelShiftController controller = new ChartPanelShiftController(this.panel);
            this.panel.addMouseListener((MouseListener)controller);
            this.panel.addMouseMotionListener((MouseMotionListener)controller);
        }
        this.panel.getChartRenderingInfo().setEntityCollection(null);
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        if (index == 0) {
            return this.localNormalizationBox;
        }
        if (index == 1) {
            return this.rotateLabels;
        }
        return null;
    }

    @Override
    public List<ParameterType> getAdditionalParameterKeys() {
        List<ParameterType> types = super.getAdditionalParameterKeys();
        types.add(new ParameterTypeBoolean("local_normalization", "Indicates if values should be normalized for each dimension between 0 and 1.", false));
        types.add(new ParameterTypeBoolean("rotate_labels", "Indicates if the domain axis labels should be rotated.", false));
        return types;
    }

    @Override
    public void setAdditionalParameter(String key, String value) {
        if ("local_normalization".equals(key)) {
            boolean distinct = Tools.booleanValue(value, false);
            this.localNormalizationBox.setSelected(distinct);
        } else if ("rotate_labels".equals(key)) {
            this.setRotateLabels(Tools.booleanValue(value, false));
        }
    }
}

