/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.UserError;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNameMapper {
    private Map<String, String> classMap = new LinkedHashMap<String, String>();

    public ClassNameMapper(String[] classNames) {
        int i = 0;
        while (i < classNames.length) {
            String completeClassName;
            String simpleClassName = completeClassName = classNames[i];
            int index = completeClassName.lastIndexOf(46);
            if (index > -1) {
                simpleClassName = completeClassName.substring(index + 1);
            }
            if (this.classMap.get(simpleClassName) == null) {
                this.classMap.put(simpleClassName, completeClassName);
            } else {
                this.classMap.put(completeClassName, completeClassName);
            }
            ++i;
        }
    }

    public String getCompleteClassName(String shortName) {
        return this.classMap.get(shortName);
    }

    public Class<?> getClassByShortName(String shortName) throws UserError {
        String completeClassName = this.getCompleteClassName(shortName);
        if (completeClassName == null) {
            completeClassName = shortName;
        }
        try {
            return Class.forName(completeClassName);
        }
        catch (ClassNotFoundException e) {
            throw new UserError(null, 904, shortName, e.getMessage());
        }
    }

    public String[] getShortClassNames() {
        String[] result = new String[this.classMap.size()];
        Iterator<String> it = this.classMap.keySet().iterator();
        int i = 0;
        while (i < this.classMap.size()) {
            result[i] = it.next();
            ++i;
        }
        return result;
    }

    public Object getInstantiation(String shortName) throws UserError {
        Object result = null;
        try {
            result = this.getClassByShortName(shortName).newInstance();
        }
        catch (InstantiationException e) {
            throw new UserError(null, 904, shortName, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new UserError(null, 904, shortName, e.getMessage());
        }
        return result;
    }
}

