/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.clustering.Centroid;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CentroidClusterModel
extends ClusterModel {
    private static final long serialVersionUID = 3780908886210272852L;
    private Collection<String> dimensionNames;
    private ArrayList<Centroid> centroids;
    private DistanceMeasure distanceMeasure;

    public CentroidClusterModel(int k, Collection<String> dimensionNames, DistanceMeasure distanceMeasure) {
        super(k);
        this.distanceMeasure = distanceMeasure;
        this.dimensionNames = dimensionNames;
        this.centroids = new ArrayList(k);
        int i = 0;
        while (i < k) {
            this.centroids.add(new Centroid(dimensionNames.size()));
            ++i;
        }
    }

    public CentroidClusterModel(int k, Attributes attributes) {
        super(k);
        LinkedList<String> dimensionNames = new LinkedList<String>();
        for (Attribute attribute : attributes) {
            dimensionNames.add(attribute.getName());
        }
        this.dimensionNames = dimensionNames;
        this.centroids = new ArrayList(k);
        int i = 0;
        while (i < k) {
            this.centroids.add(new Centroid(dimensionNames.size()));
            ++i;
        }
    }

    @Override
    public int[] getClusterAssignments(ExampleSet exampleSet) {
        int[] clusterAssignments = new int[exampleSet.size()];
        Attribute[] attributes = new Attribute[this.dimensionNames.size()];
        int i = 0;
        for (String attributeName : this.dimensionNames) {
            attributes[i] = exampleSet.getAttributes().get(attributeName);
            ++i;
        }
        double[] exampleValues = new double[attributes.length];
        int exampleIndex = 0;
        for (Example example : exampleSet) {
            i = 0;
            while (i < attributes.length) {
                exampleValues[i] = example.getValue(attributes[i]);
                ++i;
            }
            int centroidIndex = 0;
            int bestIndex = 0;
            double minimalDistance = Double.POSITIVE_INFINITY;
            for (Centroid centroid : this.centroids) {
                double distance = this.distanceMeasure.calculateDistance(exampleValues, centroid.getCentroid());
                if (distance < minimalDistance) {
                    bestIndex = centroidIndex;
                    minimalDistance = distance;
                }
                ++centroidIndex;
            }
            clusterAssignments[exampleIndex] = bestIndex;
            ++exampleIndex;
        }
        return clusterAssignments;
    }

    @Override
    public void checkCapabilities(ExampleSet exampleSet) throws OperatorException {
    }

    public String[] getAttributeNames() {
        return this.dimensionNames.toArray(new String[0]);
    }

    public double[] getCentroidCoordinates(int i) {
        return this.centroids.get(i).getCentroid();
    }

    public Centroid getCentroid(int i) {
        return this.centroids.get(i);
    }

    public void assignExample(int i, double[] asDoubleArray) {
        this.centroids.get(i).assignExample(asDoubleArray);
    }

    public boolean finishAssign() {
        boolean stable = true;
        for (Centroid centroid : this.centroids) {
            stable &= centroid.finishAssign();
        }
        return stable;
    }

    @Override
    public String getExtension() {
        return "ccm";
    }

    @Override
    public String getFileDescription() {
        return "Centroid based cluster model";
    }
}

