/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.neuralnet;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.LearnerCapability;
import com.rapidminer.operator.learner.functions.neuralnet.NeuralNetModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.joone.engine.FullSynapse;
import org.joone.engine.GaussianLayer;
import org.joone.engine.InputPatternListener;
import org.joone.engine.Layer;
import org.joone.engine.LinearLayer;
import org.joone.engine.LogarithmicLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.SineLayer;
import org.joone.engine.TanhLayer;
import org.joone.engine.learning.ComparingElement;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.engine.listeners.ErrorBasedTerminator;
import org.joone.io.MemoryInputSynapse;
import org.joone.io.MemoryOutputSynapse;
import org.joone.io.StreamInputSynapse;
import org.joone.net.NeuralNet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeuralNetLearner
extends AbstractLearner
implements NeuralNetListener {
    public static final String PARAMETER_INPUT_LAYER_TYPE = "input_layer_type";
    public static final String PARAMETER_OUTPUT_LAYER_TYPE = "output_layer_type";
    public static final String PARAMETER_DEFAULT_NUMBER_OF_HIDDEN_LAYERS = "default_number_of_hidden_layers";
    public static final String PARAMETER_DEFAULT_HIDDEN_LAYER_SIZE = "default_hidden_layer_size";
    public static final String PARAMETER_DEFAULT_HIDDEN_LAYER_TYPE = "default_hidden_layer_type";
    public static final String PARAMETER_HIDDEN_LAYER_TYPES = "hidden_layer_types";
    public static final String PARAMETER_TRAINING_CYCLES = "training_cycles";
    public static final String PARAMETER_LEARNING_RATE = "learning_rate";
    public static final String PARAMETER_MOMENTUM = "momentum";
    public static final String PARAMETER_ERROR_EPSILON = "error_epsilon";
    private static final String[] LAYER_TYPES = new String[]{"linear", "sigmoid", "tanh", "sine", "logarithmic", "gaussian"};
    private static final int LINEAR = 0;
    private static final int SIGMOID = 1;
    private static final int TANH = 2;
    private static final int SINE = 3;
    private static final int LOGARITHMIC = 4;
    private static final int GAUSSIAN = 5;
    private NeuralNet neuralNet;
    private MemoryInputSynapse inputSynapse;
    private MemoryInputSynapse desiredOutputSynapse;
    private double minLabel;
    private double maxLabel;

    public NeuralNetLearner(OperatorDescription description) {
        super(description);
    }

    private int getDefaultLayerSize(ExampleSet exampleSet) {
        return (int)Math.round((double)exampleSet.getAttributes().size() / 2.0) + 1;
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label.isNominal() && label.getMapping().size() != 2) {
            throw new UserError((Operator)this, 114, this.getName(), label.getName());
        }
        this.initNeuralNet(exampleSet);
        this.train(exampleSet);
        return new NeuralNetModel(exampleSet, this.neuralNet, exampleSet.getAttributes().size(), this.minLabel, this.maxLabel);
    }

    private Layer createLayer(String layerTypeName, int size, int counter) {
        return this.createLayer("Hidden", layerTypeName, size, counter);
    }

    private Layer createLayer(String layerName, String layerTypeName, int size, int counter) {
        LinearLayer layer = null;
        if (LAYER_TYPES[0].equals(layerTypeName.toLowerCase())) {
            layer = new LinearLayer();
        } else if (LAYER_TYPES[1].equals(layerTypeName.toLowerCase())) {
            layer = new SigmoidLayer();
        } else if (LAYER_TYPES[2].equals(layerTypeName.toLowerCase())) {
            layer = new TanhLayer();
        } else if (LAYER_TYPES[3].equals(layerTypeName.toLowerCase())) {
            layer = new SineLayer();
        } else if (LAYER_TYPES[4].equals(layerTypeName.toLowerCase())) {
            layer = new LogarithmicLayer();
        } else if (LAYER_TYPES[5].equals(layerTypeName.toLowerCase())) {
            layer = new GaussianLayer();
        } else {
            this.logWarning("Cannot create layer of type '" + layerTypeName + "', using sigmoid layer instead.");
            layer = new SigmoidLayer();
        }
        layer.setRows(size);
        String name = layerName;
        if (counter >= 0) {
            name = String.valueOf(name) + "-" + counter;
        }
        name = String.valueOf(name) + " [" + layerTypeName + "]";
        layer.setLayerName(name);
        return layer;
    }

    private void initNeuralNet(ExampleSet exampleSet) throws UndefinedParameterError {
        Layer input = this.createLayer("Input", LAYER_TYPES[this.getParameterAsInt(PARAMETER_INPUT_LAYER_TYPE)], exampleSet.getAttributes().size(), -1);
        Layer output = this.createLayer("Output", LAYER_TYPES[this.getParameterAsInt(PARAMETER_OUTPUT_LAYER_TYPE)], 1, -1);
        LinkedList<Layer> allHiddenLayers = new LinkedList<Layer>();
        List<String[]> hiddenLayerList = this.getParameterList(PARAMETER_HIDDEN_LAYER_TYPES);
        Iterator<String[]> i = hiddenLayerList.iterator();
        int counter = 1;
        while (i.hasNext()) {
            String[] typeSizePair = i.next();
            String layerType = typeSizePair[0];
            Integer layerSizeObject = Integer.valueOf(typeSizePair[1]);
            int layerSize = layerSizeObject;
            if (layerSize <= 0) {
                layerSize = this.getDefaultLayerSize(exampleSet);
            }
            Layer hiddenLayer = this.createLayer(layerType, layerSize, counter);
            allHiddenLayers.add(hiddenLayer);
            ++counter;
        }
        if (allHiddenLayers.size() == 0) {
            this.log("No hidden layers defined. Using default hidden layers.");
            String layerType = LAYER_TYPES[this.getParameterAsInt(PARAMETER_DEFAULT_HIDDEN_LAYER_TYPE)];
            int layerSize = this.getParameterAsInt(PARAMETER_DEFAULT_HIDDEN_LAYER_SIZE);
            if (layerSize <= 0) {
                layerSize = this.getDefaultLayerSize(exampleSet);
            }
            int p = 0;
            while (p < this.getParameterAsInt(PARAMETER_DEFAULT_NUMBER_OF_HIDDEN_LAYERS)) {
                allHiddenLayers.add(this.createLayer(layerType, layerSize, p + 1));
                ++p;
            }
        }
        Layer last = null;
        for (Layer current : allHiddenLayers) {
            if (last != null) {
                FullSynapse synapse_HH = new FullSynapse();
                last.addOutputSynapse((OutputPatternListener)synapse_HH);
                current.addInputSynapse((InputPatternListener)synapse_HH);
            }
            last = current;
        }
        FullSynapse synapse_IH = new FullSynapse();
        input.addOutputSynapse((OutputPatternListener)synapse_IH);
        ((Layer)allHiddenLayers.getFirst()).addInputSynapse((InputPatternListener)synapse_IH);
        FullSynapse synapse_HO = new FullSynapse();
        ((Layer)allHiddenLayers.getLast()).addOutputSynapse((OutputPatternListener)synapse_HO);
        output.addInputSynapse((InputPatternListener)synapse_HO);
        this.inputSynapse = new MemoryInputSynapse();
        input.addInputSynapse((InputPatternListener)this.inputSynapse);
        MemoryOutputSynapse outputSynapse = new MemoryOutputSynapse();
        output.addOutputSynapse((OutputPatternListener)outputSynapse);
        TeachingSynapse trainer = new TeachingSynapse();
        this.desiredOutputSynapse = new MemoryInputSynapse();
        trainer.setDesired((StreamInputSynapse)this.desiredOutputSynapse);
        this.neuralNet = new NeuralNet();
        this.neuralNet.addLayer(input, 0);
        Iterator h = allHiddenLayers.iterator();
        while (h.hasNext()) {
            this.neuralNet.addLayer((Layer)h.next(), 1);
        }
        this.neuralNet.addLayer(output, 2);
        this.neuralNet.setTeacher((ComparingElement)trainer);
        output.addOutputSynapse((OutputPatternListener)trainer);
        ErrorBasedTerminator terminator = new ErrorBasedTerminator(this.getParameterAsDouble(PARAMETER_ERROR_EPSILON));
        terminator.setNeuralNet(this.neuralNet);
        this.neuralNet.getMonitor().addNeuralNetListener((NeuralNetListener)terminator);
    }

    public void train(ExampleSet exampleSet) throws UndefinedParameterError {
        double[][] inputArray = this.createInputData(exampleSet);
        this.inputSynapse.setInputArray(inputArray);
        this.inputSynapse.setAdvancedColumnSelector("1-" + exampleSet.getAttributes().size());
        this.desiredOutputSynapse.setInputArray(inputArray);
        this.desiredOutputSynapse.setAdvancedColumnSelector(String.valueOf(exampleSet.getAttributes().size() + 1));
        Monitor monitor = this.neuralNet.getMonitor();
        monitor.setLearningRate(this.getParameterAsDouble(PARAMETER_LEARNING_RATE));
        monitor.setMomentum(this.getParameterAsDouble(PARAMETER_MOMENTUM));
        monitor.setTrainingPatterns(inputArray.length);
        monitor.setTotCicles(this.getParameterAsInt(PARAMETER_TRAINING_CYCLES));
        monitor.setLearning(true);
        this.neuralNet.getMonitor().addNeuralNetListener((NeuralNetListener)this);
        this.neuralNet.start();
        this.neuralNet.getMonitor().Go();
        this.neuralNet.join();
    }

    public void cicleTerminated(NeuralNetEvent e) {
    }

    public void errorChanged(NeuralNetEvent e) {
    }

    public void netStarted(NeuralNetEvent e) {
        this.log("learning started.");
    }

    public void netStopped(NeuralNetEvent e) {
        this.log("learning finished.");
    }

    public void netStoppedError(NeuralNetEvent e, String error) {
        this.logError("learning stopped, error: " + error);
    }

    private double[][] createInputData(ExampleSet exampleSet) {
        double[][] result = null;
        result = new double[exampleSet.size()][exampleSet.getAttributes().size() + 1];
        int counter = 0;
        Iterator i = exampleSet.iterator();
        this.maxLabel = Double.NEGATIVE_INFINITY;
        this.minLabel = Double.POSITIVE_INFINITY;
        Attribute label = exampleSet.getAttributes().getLabel();
        while (i.hasNext()) {
            Example example = (Example)i.next();
            int a = 0;
            for (Attribute attribute : example.getAttributes()) {
                result[counter][a++] = example.getValue(attribute);
            }
            double labelValue = example.getValue(label);
            if (label.isNominal()) {
                result[counter][exampleSet.getAttributes().size()] = (double)label.getMapping().getPositiveIndex() == labelValue ? 1.0 : 0.0;
            } else {
                result[counter][exampleSet.getAttributes().size()] = labelValue;
                this.maxLabel = Math.max(this.maxLabel, labelValue);
                this.minLabel = Math.min(this.minLabel, labelValue);
            }
            ++counter;
        }
        if (!label.isNominal()) {
            int l = 0;
            while (l < result.length) {
                result[l][exampleSet.getAttributes().size()] = (result[l][exampleSet.getAttributes().size()] - this.minLabel) / (this.maxLabel - this.minLabel);
                ++l;
            }
        }
        return result;
    }

    @Override
    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.POLYNOMINAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.BINOMINAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.BINOMINAL_CLASS) {
            return true;
        }
        return lc == LearnerCapability.NUMERICAL_CLASS;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_INPUT_LAYER_TYPE, "The default layer type for the input layers.", LAYER_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_OUTPUT_LAYER_TYPE, "The default layer type for the output layers.", LAYER_TYPES, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_DEFAULT_NUMBER_OF_HIDDEN_LAYERS, "The number of hidden layers. Only used if no layers are defined by the list hidden_layer_types.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_DEFAULT_HIDDEN_LAYER_SIZE, "The default size  of hidden layers. Only used if no layers are defined by the list hidden_layer_types. -1 means size (number of attributes + number of classes) / 2", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeCategory(PARAMETER_DEFAULT_HIDDEN_LAYER_TYPE, "The default layer type for the hidden layers. Only used if the parameter list hidden_layer_types is not defined.", LAYER_TYPES, 1));
        types.add(new ParameterTypeList(PARAMETER_HIDDEN_LAYER_TYPES, "Describes the name, the size, and the type of all hidden layers", new ParameterTypeInt("hidden_layer_sizes", "The type and the size of the hidden layers, e.g. sigmoid and 5. A size of <= 0 leads to a layer size of (number_of_attributes + number of classes) / 2.", -1, Integer.MAX_VALUE, -1)));
        type = new ParameterTypeInt(PARAMETER_TRAINING_CYCLES, "The number of training cycles used for the neural network training.", 1, Integer.MAX_VALUE, 200);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_LEARNING_RATE, "The learning rate determines by how much we change the weights at each step.", 0.0, 1.0, 0.3);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_MOMENTUM, "The momentum simply adds a fraction of the previous weight update to the current one (prevent local maxima and smoothes optimization directions).", 0.0, 1.0, 0.2));
        types.add(new ParameterTypeDouble(PARAMETER_ERROR_EPSILON, "The optimization is stopped if the training error gets below this epsilon value.", 0.0, Double.POSITIVE_INFINITY, 0.05));
        return types;
    }
}

