/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.tree.AccuracyCriterion;
import com.rapidminer.operator.learner.tree.Criterion;
import com.rapidminer.operator.learner.tree.GainRatioCriterion;
import com.rapidminer.operator.learner.tree.GiniIndexCriterion;
import com.rapidminer.operator.learner.tree.InfoGainCriterion;
import com.rapidminer.operator.learner.tree.MinimalGainHandler;
import com.rapidminer.operator.learner.tree.Pruner;
import com.rapidminer.operator.learner.tree.SplitPreprocessing;
import com.rapidminer.operator.learner.tree.Terminator;
import com.rapidminer.operator.learner.tree.Tree;
import com.rapidminer.operator.learner.tree.TreeBuilder;
import com.rapidminer.operator.learner.tree.TreeModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Tools;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeLearner
extends AbstractLearner {
    public static final String PARAMETER_CRITERION = "criterion";
    public static final String PARAMETER_MINIMAL_SIZE_FOR_SPLIT = "minimal_size_for_split";
    public static final String PARAMETER_MINIMAL_LEAF_SIZE = "minimal_leaf_size";
    public static final String PARAMETER_MINIMAL_GAIN = "minimal_gain";
    public static final String[] CRITERIA_NAMES = new String[]{"gain_ratio", "information_gain", "gini_index", "accuracy"};
    public static final Class[] CRITERIA_CLASSES = new Class[]{GainRatioCriterion.class, InfoGainCriterion.class, GiniIndexCriterion.class, AccuracyCriterion.class};
    public static final int CRITERION_GAIN_RATIO = 0;
    public static final int CRITERION_INFO_GAIN = 1;
    public static final int CRITERION_GINI_INDEX = 2;
    public static final int CRITERION_ACCURACY = 3;

    public AbstractTreeLearner(OperatorDescription description) {
        super(description);
    }

    public abstract List<Terminator> getTerminationCriteria(ExampleSet var1) throws OperatorException;

    public abstract Pruner getPruner() throws OperatorException;

    public SplitPreprocessing getSplitPreprocessing() {
        return null;
    }

    @Override
    public Model learn(ExampleSet eSet) throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)eSet.clone();
        TreeBuilder builder = this.getTreeBuilder(exampleSet);
        Tree root = builder.learnTree(exampleSet);
        return new TreeModel(exampleSet, root);
    }

    protected abstract TreeBuilder getTreeBuilder(ExampleSet var1) throws OperatorException;

    protected Criterion createCriterion(double minimalGain) throws UndefinedParameterError {
        String criterionName = this.getParameterAsString(PARAMETER_CRITERION);
        Class criterionClass = null;
        int i = 0;
        while (i < CRITERIA_NAMES.length) {
            if (CRITERIA_NAMES[i].equals(criterionName)) {
                criterionClass = CRITERIA_CLASSES[i];
            }
            ++i;
        }
        if (criterionClass == null && criterionName != null) {
            try {
                criterionClass = Tools.classForName(criterionName);
            }
            catch (ClassNotFoundException e) {
                this.logWarning("Cannot find criterion '" + criterionName + "' and cannot instantiate a class with this name. Using gain ratio criterion instead.");
            }
        }
        if (criterionClass != null) {
            try {
                Criterion criterion = (Criterion)criterionClass.newInstance();
                if (criterion instanceof MinimalGainHandler) {
                    ((MinimalGainHandler)((Object)criterion)).setMinimalGain(minimalGain);
                }
                return criterion;
            }
            catch (InstantiationException e) {
                this.logWarning("Cannot instantiate criterion class '" + criterionClass.getName() + "'. Using gain ratio criterion instead.");
                return new GainRatioCriterion(minimalGain);
            }
            catch (IllegalAccessException e) {
                this.logWarning("Cannot access criterion class '" + criterionClass.getName() + "'. Using gain ratio criterion instead.");
                return new GainRatioCriterion(minimalGain);
            }
        }
        this.log("No relevance criterion defined, using gain ratio...");
        return new GainRatioCriterion(minimalGain);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeStringCategory(PARAMETER_CRITERION, "Specifies the used criterion for selecting attributes and numerical splits.", CRITERIA_NAMES, CRITERIA_NAMES[0]);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MINIMAL_SIZE_FOR_SPLIT, "The minimal size of a node in order to allow a split.", 1, Integer.MAX_VALUE, 4);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MINIMAL_LEAF_SIZE, "The minimal size of all leaves.", 1, Integer.MAX_VALUE, 2);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_MINIMAL_GAIN, "The minimal gain which must be achieved in order to produce a split.", 0.0, Double.POSITIVE_INFINITY, 0.1));
        return types;
    }
}

