/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.weighting.ChiSquaredWeighting;
import com.rapidminer.operator.learner.tree.Benefit;
import com.rapidminer.operator.learner.tree.DecisionTreeLearner;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.OperatorService;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CHAIDLearner
extends DecisionTreeLearner {
    public CHAIDLearner(OperatorDescription description) {
        super(description);
    }

    protected Benefit calculateBenefit(ExampleSet trainingSet, Attribute attribute) throws OperatorException {
        ChiSquaredWeighting weightOp = null;
        try {
            weightOp = OperatorService.createOperator(ChiSquaredWeighting.class);
        }
        catch (OperatorCreationException e) {
            this.logWarning("Cannot create chi squared calculation operator.");
        }
        double weight = Double.NaN;
        if (weightOp != null) {
            IOContainer output = weightOp.apply(new IOContainer(trainingSet));
            AttributeWeights weights = output.remove(AttributeWeights.class);
            weight = weights.getWeight(attribute.getName());
        }
        if (!Double.isNaN(weight)) {
            return new Benefit(weight, attribute);
        }
        return null;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        Iterator<ParameterType> i = types.iterator();
        while (i.hasNext()) {
            if (!i.next().getKey().equals("criterion")) continue;
            i.remove();
        }
        return types;
    }
}

