/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.condition.AllInnerOperatorCondition;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatorSelector
extends OperatorChain {
    public static final String PARAMETER_SELECT_WHICH = "select_which";

    public OperatorSelector(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        int operatorIndex = this.getParameterAsInt(PARAMETER_SELECT_WHICH);
        if (operatorIndex < 1 || operatorIndex > this.getNumberOfOperators()) {
            throw new UserError((Operator)this, 207, operatorIndex, PARAMETER_SELECT_WHICH, "must be between 1 and the number of inner operators.");
        }
        Operator operator = this.getOperator(operatorIndex - 1);
        return operator.apply(this.getInput()).getIOObjects();
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        try {
            int operatorIndex = 0;
            try {
                operatorIndex = this.getParameterAsInt(PARAMETER_SELECT_WHICH);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (operatorIndex < 1 || operatorIndex > this.getNumberOfOperators()) {
                return new AllInnerOperatorCondition(new Class[0], new Class[0]);
            }
            Operator operator = this.getOperator(operatorIndex - 1);
            return new AllInnerOperatorCondition(operator.getInputClasses(), operator.getOutputClasses());
        }
        catch (UndefinedParameterError e) {
            return new AllInnerOperatorCondition(new Class[0], new Class[0]);
        }
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public Class<?>[] getInputClasses() {
        try {
            int operatorIndex = 0;
            try {
                operatorIndex = this.getParameterAsInt(PARAMETER_SELECT_WHICH);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (operatorIndex < 1 || operatorIndex > this.getNumberOfOperators()) {
                return new Class[0];
            }
            Operator operator = this.getOperator(operatorIndex - 1);
            return operator.getInputClasses();
        }
        catch (Exception e) {
            return new Class[0];
        }
    }

    @Override
    public Class<?>[] getOutputClasses() {
        try {
            int operatorIndex = 0;
            try {
                operatorIndex = this.getParameterAsInt(PARAMETER_SELECT_WHICH);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (operatorIndex < 1 || operatorIndex > this.getNumberOfOperators()) {
                return new Class[0];
            }
            Operator operator = this.getOperator(operatorIndex - 1);
            return operator.getOutputClasses();
        }
        catch (Exception e) {
            return new Class[0];
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_SELECT_WHICH, "Indicates which inner operator should be currently employed by this operator on the input objects.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

