/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.Process;
import com.rapidminer.operator.Operator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterValue {
    private static final long serialVersionUID = -6847818423564185071L;
    private String operator;
    private String parameterKey;
    private String parameterValue;

    public ParameterValue(String operator, String parameterKey, String parameterValue) {
        this.operator = operator;
        this.parameterKey = parameterKey;
        this.parameterValue = parameterValue;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getParameterKey() {
        return this.parameterKey;
    }

    public String getParameterValue() {
        return this.parameterValue;
    }

    public String toString() {
        return String.valueOf(this.operator) + "." + this.parameterKey + "\t= " + this.parameterValue;
    }

    public void apply(Process process, Map<String, String> nameMap) {
        String opName = nameMap.get(this.operator);
        if (opName == null) {
            opName = this.operator;
        }
        process.getLog().log("Setting parameter '" + this.parameterKey + "' of operator '" + opName + "' to '" + this.parameterValue + "'.", 2);
        Operator operator = process.getOperator(opName);
        if (operator == null) {
            process.getLog().log("No such operator: '" + opName + "'.", 2);
        } else {
            operator.getParameters().setParameter(this.parameterKey, this.parameterValue);
        }
    }
}

