/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta.branch;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.meta.branch.ProcessBranch;
import com.rapidminer.operator.meta.branch.ProcessBranchCondition;
import com.rapidminer.operator.performance.PerformanceVector;

public class MinPerformanceValueCondition
implements ProcessBranchCondition {
    public boolean check(ProcessBranch operator, String value) throws OperatorException {
        if (value == null) {
            throw new UserError((Operator)operator, 205, "condition_value");
        }
        double minValue = Double.NEGATIVE_INFINITY;
        try {
            minValue = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new UserError((Operator)operator, 207, value, "condition_value", e);
        }
        PerformanceVector performance = operator.getConditionInput(PerformanceVector.class);
        return performance.getMainCriterion().getAverage() > minValue;
    }
}

