/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter.attributes;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.filter.attributes.AttributeFilterCondition;
import com.rapidminer.operator.preprocessing.filter.attributes.DateAttributeFilter;
import com.rapidminer.operator.preprocessing.filter.attributes.MissingValuesAttributeFilter;
import com.rapidminer.operator.preprocessing.filter.attributes.NameAttributeFilter;
import com.rapidminer.operator.preprocessing.filter.attributes.NoMissingValuesAttributeFilter;
import com.rapidminer.operator.preprocessing.filter.attributes.NominalAttributeFilter;
import com.rapidminer.operator.preprocessing.filter.attributes.NumericValueAttributeFilter;
import com.rapidminer.operator.preprocessing.filter.attributes.NumericalAttributeFilter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.LogService;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeFilterConditions {
    public static final String PARAMETER_CONDITION_NAME = "condition_class";
    public static final String PARAMETER_PARAMETER_STRING = "parameter_string";
    public static final int CONDITION_NO_MISSING_VALUES = 0;
    public static final int CONDITION_NUMERIC_VALUE_FILTER = 2;
    public static final int CONDITION_ATTRIBUTE_NAME_FILTER = 3;
    public static final int CONDITION_IS_NOMINAL = 4;
    public static final int CONDITION_IS_NUMERICAL = 5;
    public static final int CONDITION_IS_DATE = 6;
    public static String[] CONDITION_NAMES = new String[]{"no_missing_values", "missing_values", "numeric_value_filter", "attribute_name_filter", "is_nominal", "is_numerical", "is_date"};
    private static Class[] CONDITION_CLASSES = new Class[]{NoMissingValuesAttributeFilter.class, MissingValuesAttributeFilter.class, NumericValueAttributeFilter.class, NameAttributeFilter.class, NominalAttributeFilter.class, NumericalAttributeFilter.class, DateAttributeFilter.class};

    public static void registerCondition(String name, Class conditionClass) {
        String[] newConditionNames = new String[CONDITION_NAMES.length + 1];
        System.arraycopy(CONDITION_NAMES, 0, newConditionNames, 0, CONDITION_NAMES.length);
        newConditionNames[newConditionNames.length - 1] = name;
        CONDITION_NAMES = newConditionNames;
        Class[] newConditionClasses = new Class[CONDITION_CLASSES.length + 1];
        System.arraycopy(CONDITION_CLASSES, 0, newConditionClasses, 0, CONDITION_CLASSES.length);
        newConditionClasses[newConditionClasses.length - 1] = conditionClass;
        CONDITION_CLASSES = newConditionClasses;
    }

    public static AttributeFilterCondition createCondition(Operator operator) throws UserError {
        Class conditionClass = CONDITION_CLASSES[operator.getParameterAsInt(PARAMETER_CONDITION_NAME)];
        try {
            AttributeFilterCondition condition = (AttributeFilterCondition)conditionClass.newInstance();
            condition.init(operator);
            return condition;
        }
        catch (IllegalAccessException e) {
            throw new UserError(operator, 904, CONDITION_NAMES[operator.getParameterAsInt(PARAMETER_CONDITION_NAME)], "'" + conditionClass.getName() + "' cannot access zero argument constructor " + conditionClass.getName());
        }
        catch (InstantiationException e) {
            throw new UserError(operator, 904, CONDITION_NAMES[operator.getParameterAsInt(PARAMETER_CONDITION_NAME)], String.valueOf(conditionClass.getName()) + ": cannot create condition (" + e.getMessage() + ").");
        }
    }

    public static final List<ParameterType> getParameterTypes(Operator operator) {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_CONDITION_NAME, "The condition for filtering.", CONDITION_NAMES, 0);
        type.setExpert(false);
        types.add(type);
        int i = 0;
        while (i < CONDITION_CLASSES.length) {
            try {
                AttributeFilterCondition condition = (AttributeFilterCondition)CONDITION_CLASSES[i].newInstance();
                List<ParameterType> conditionTypes = condition.getParameterTypes(operator);
                for (ParameterType conditionType : conditionTypes) {
                    conditionType.registerDependencyCondition(new EqualTypeCondition(operator, PARAMETER_CONDITION_NAME, true, i));
                    types.add(conditionType);
                }
            }
            catch (InstantiationException e) {
                LogService.getGlobal().logError("Could not create AttributeFilterCondition: " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                LogService.getGlobal().logError("Could not create AttributeFilterCondition: " + e.getMessage());
            }
            ++i;
        }
        type = new ParameterTypeString(PARAMETER_PARAMETER_STRING, "The parameter for the name filter and numeric value filter.", true);
        type.registerDependencyCondition(new EqualTypeCondition(operator, PARAMETER_CONDITION_NAME, true, 2, 3));
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

