/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.expressions;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.Add;
import org.nfunk.jep.function.Divide;
import org.nfunk.jep.function.PostfixMathCommand;

public class Average
extends PostfixMathCommand {
    private Add addFun = new Add();
    private Divide divideFun = new Divide();

    public Average() {
        this.numberOfParameters = -1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        if (this.curNumberOfParameters < 1) {
            throw new ParseException("No arguments for 'avg'");
        }
        Object sum = stack.pop();
        if (!(sum instanceof Double)) {
            throw new ParseException("Invalid parameter type, only numbers are allowed for 'min'.");
        }
        int i = 1;
        while (i < this.curNumberOfParameters) {
            Object param = stack.pop();
            if (!(param instanceof Double)) {
                throw new ParseException("Invalid parameter type, only numbers are allowed for 'avg'.");
            }
            sum = this.addFun.add(param, sum);
            ++i;
        }
        sum = this.divideFun.div(sum, (Object)this.curNumberOfParameters);
        stack.push(sum);
    }
}

