/*
 * Decompiled with CFR 0.152.
 */
package marytts.cart;

import marytts.cart.DecisionNode;

public abstract class Node {
    protected boolean isRoot;
    protected Node mother;
    protected int nodeIndex;

    public void setMother(Node node, int nodeIndex) {
        this.mother = node;
        this.nodeIndex = nodeIndex;
    }

    public Node getMother() {
        return this.mother;
    }

    public int getNodeIndex() {
        return this.nodeIndex;
    }

    public void setIsRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isDecisionNode() {
        return false;
    }

    public boolean isLeafNode() {
        return false;
    }

    public boolean isDirectedGraphNode() {
        return false;
    }

    public Node getRootNode() {
        if (this.isRoot) {
            assert (this.mother == null);
            return this;
        }
        assert (this.mother != null) : " I am not root but I have no mother :-(";
        return this.mother.getRootNode();
    }

    public String getDecisionPath() {
        String ancestorInfo = this.mother == null ? "null" : (this.mother.isDecisionNode() ? ((DecisionNode)this.mother).getDecisionPath(this.getNodeIndex()) : this.mother.getDecisionPath());
        return ancestorInfo + " - " + this.toString();
    }

    public abstract int getNumberOfNodes();

    public abstract int getNumberOfData();

    public abstract Object getAllData();

    protected abstract void fillData(Object var1, int var2, int var3);

    public String toString(String prefix) {
        return prefix + this.toString();
    }
}

