/*
 * Decompiled with CFR 0.152.
 */
package marytts.machinelearning;

import java.util.Arrays;

public class Cluster {
    public double[] meanVector;
    public double[][] covMatrix;
    public double[][] invCovMatrix;
    public boolean isDiagonalCovariance;

    public Cluster() {
        this(0, true);
    }

    public Cluster(int dimension, boolean isDiagonalCovariance) {
        this.allocate(dimension, isDiagonalCovariance);
    }

    public void allocate(int dimension, boolean isDiagonalCovarianceIn) {
        if (dimension > 0) {
            this.isDiagonalCovariance = isDiagonalCovarianceIn;
            this.meanVector = new double[dimension];
            Arrays.fill(this.meanVector, 0.0);
            if (this.isDiagonalCovariance) {
                this.covMatrix = new double[1][];
                this.covMatrix[0] = new double[dimension];
                Arrays.fill(this.covMatrix[0], 0.0);
                this.invCovMatrix = new double[1][];
                this.invCovMatrix[0] = new double[dimension];
                Arrays.fill(this.invCovMatrix[0], 0.0);
            } else {
                int i;
                this.covMatrix = new double[dimension][];
                for (i = 0; i < dimension; ++i) {
                    this.covMatrix[i] = new double[dimension];
                    Arrays.fill(this.covMatrix[i], 0.0);
                }
                this.invCovMatrix = new double[dimension][];
                for (i = 0; i < dimension; ++i) {
                    this.invCovMatrix[i] = new double[dimension];
                    Arrays.fill(this.invCovMatrix[i], 0.0);
                }
            }
        } else {
            this.meanVector = null;
            this.covMatrix = null;
            this.invCovMatrix = null;
        }
    }

    public double[] getCovarianceDiagonal() {
        double[] diagonal = null;
        if (this.covMatrix != null && this.covMatrix[0] != null && this.covMatrix[0].length > 0) {
            diagonal = new double[this.covMatrix[0].length];
            if (this.isDiagonalCovariance) {
                System.arraycopy(this.covMatrix[0], 0, diagonal, 0, this.covMatrix[0].length);
            } else {
                for (int i = 0; i < this.covMatrix.length; ++i) {
                    diagonal[i] = this.covMatrix[i][i];
                }
            }
        }
        return diagonal;
    }
}

