/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal;

import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.analysis.PitchMarks;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.signalproc.sinusoidal.BaseSinusoidalAnalyzer;
import marytts.signalproc.sinusoidal.MultiresolutionSinusoidalAnalyzer;
import marytts.signalproc.sinusoidal.OverlapAddSinusoidalSynthesizer;
import marytts.signalproc.sinusoidal.PeakMatchedSinusoidalSynthesizer;
import marytts.signalproc.sinusoidal.PitchSynchronousSinusoidalAnalyzer;
import marytts.signalproc.sinusoidal.SinusoidalAnalysisParams;
import marytts.signalproc.sinusoidal.SinusoidalAnalyzer;
import marytts.signalproc.sinusoidal.SinusoidalTracks;
import marytts.signalproc.sinusoidal.TrackModifier;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class ProsodyModifier {
    public int fs;

    public ProsodyModifier(int samplingRate) {
        this.fs = samplingRate;
    }

    public double[] process(double[] x, double[] f0s, float f0_ws, float f0_ss, boolean isVoicingAdaptiveTimeScaling, float timeScalingVoicingThreshold, boolean isVoicingAdaptivePitchScaling, float timeScale, float pitchScale, float skipSizeInSeconds, float deltaInHz, float numPeriods, boolean bRefinePeakEstimatesParabola, boolean bRefinePeakEstimatesBias, boolean bSpectralReassignment, boolean bAdjustNeighFreqDependent, boolean isSilentSynthesis, double absMaxDesired, int spectralEnvelopeType, int analyzerType, int synthesizerType, int pitchMarkOffset, int sysPhaseModMethod, int sysAmpModMethod) throws Exception {
        float[] tScales = new float[1];
        float[] tScalesTimes = new float[1];
        tScales[0] = timeScale;
        tScalesTimes[0] = skipSizeInSeconds;
        float[] pScales = new float[1];
        float[] pScalesTimes = new float[1];
        pScales[0] = pitchScale;
        pScalesTimes[0] = skipSizeInSeconds;
        return this.process(x, f0s, f0_ws, f0_ss, isVoicingAdaptiveTimeScaling, timeScalingVoicingThreshold, isVoicingAdaptivePitchScaling, tScales, tScalesTimes, pScales, pScalesTimes, skipSizeInSeconds, deltaInHz, numPeriods, bRefinePeakEstimatesParabola, bRefinePeakEstimatesBias, bSpectralReassignment, bAdjustNeighFreqDependent, isSilentSynthesis, absMaxDesired, spectralEnvelopeType, analyzerType, synthesizerType, pitchMarkOffset, sysPhaseModMethod, sysAmpModMethod);
    }

    public double[] process(double[] x, double[] f0s, float f0_ws, float f0_ss, boolean isVoicingAdaptiveTimeScaling, float timeScalingVoicingThreshold, boolean isVoicingAdaptivePitchScaling, float[] timeScales, float[] timeScalesTimes, float[] pitchScales, float[] pitchScalesTimes, float skipSizeInSeconds, float deltaInHz, float numPeriods, boolean bRefinePeakEstimatesParabola, boolean bRefinePeakEstimatesBias, boolean bSpectralReassignment, boolean bAdjustNeighFreqDependent, boolean isSilentSynthesis, double absMaxDesired, int spectralEnvelopeType, int analyzerType, int synthesizerType, int pitchMarkOffset, int sysPhaseModMethod, int sysAmpModMethod) throws Exception {
        int windowType = 3;
        PitchMarks pm = SignalProcUtils.pitchContour2pitchMarks(f0s, this.fs, x.length, f0_ws, f0_ss, false, pitchMarkOffset);
        BaseSinusoidalAnalyzer an = null;
        SinusoidalTracks[] st = null;
        SinusoidalAnalysisParams params = new SinusoidalAnalysisParams(this.fs, 0.0, 0.5 * (double)this.fs, windowType, bRefinePeakEstimatesParabola, bRefinePeakEstimatesBias, bSpectralReassignment, bAdjustNeighFreqDependent);
        if (analyzerType == 1) {
            an = new SinusoidalAnalyzer(params);
            st = new SinusoidalTracks[]{an.analyzeFixedRate(x, f0_ws, f0_ss, deltaInHz, spectralEnvelopeType, f0s, f0_ws, f0_ss)};
        } else if (analyzerType == 2) {
            an = new PitchSynchronousSinusoidalAnalyzer(params);
            st = new SinusoidalTracks[]{((PitchSynchronousSinusoidalAnalyzer)an).analyzePitchSynchronous(x, pm, numPeriods, skipSizeInSeconds, deltaInHz, spectralEnvelopeType)};
        } else if (analyzerType == 3) {
            int multiresolutionFilterbankType = 1;
            int numBands = 4;
            double lowestBandWindowSizeInSeconds = 0.02;
            boolean bFreqLimitedAnalysis = true;
            an = new MultiresolutionSinusoidalAnalyzer(multiresolutionFilterbankType, numBands, this.fs);
            st = ((MultiresolutionSinusoidalAnalyzer)an).analyze(x, lowestBandWindowSizeInSeconds, windowType, bRefinePeakEstimatesParabola, bRefinePeakEstimatesBias, bSpectralReassignment, bAdjustNeighFreqDependent, bFreqLimitedAnalysis);
        } else if (analyzerType != 4) {
            System.out.println("Invalid sinusoidal analyzer...");
            return null;
        }
        SinusoidalTracks[] stMod = new SinusoidalTracks[st.length];
        for (int i = 0; i < st.length; ++i) {
            stMod[i] = TrackModifier.modify(st[i], f0s, f0_ss, f0_ws, pm.pitchMarks, st[i].voicings, numPeriods, isVoicingAdaptiveTimeScaling, timeScalingVoicingThreshold, isVoicingAdaptivePitchScaling, timeScales, timeScalesTimes, pitchScales, pitchScalesTimes, pitchMarkOffset, sysAmpModMethod, sysPhaseModMethod);
        }
        double[] y = null;
        if (synthesizerType == 1) {
            PeakMatchedSinusoidalSynthesizer synthesizer = new PeakMatchedSinusoidalSynthesizer(this.fs);
            y = synthesizer.synthesize(stMod, isSilentSynthesis);
        } else if (synthesizerType == 1) {
            OverlapAddSinusoidalSynthesizer synthesizer = new OverlapAddSinusoidalSynthesizer(this.fs);
            y = synthesizer.synthesize(stMod, isSilentSynthesis);
        } else {
            throw new Exception("Unknown sinusoidal synthesizer type!");
        }
        if (y != null) {
            y = MathUtils.normalizeToAbsMax(y, absMaxDesired);
        }
        return y;
    }

    public static void main(String[] args) throws Exception {
        ProsodyModifier.main2(args);
    }

    public static void main2(String[] args) throws Exception {
        int n;
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[0]));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] x = signal.getAllData();
        PitchReaderWriter f0 = null;
        String strPitchFile = args[0].substring(0, args[0].length() - 4) + ".ptc";
        f0 = new PitchReaderWriter(strPitchFile);
        float deltaInHz = 50.0f;
        float numPeriods = PitchSynchronousSinusoidalAnalyzer.DEFAULT_ANALYSIS_PERIODS;
        boolean isSilentSynthesis = false;
        boolean bRefinePeakEstimatesParabola = false;
        boolean bRefinePeakEstimatesBias = false;
        boolean bSpectralReassignment = false;
        boolean bAdjustNeighFreqDependent = false;
        double absMaxOriginal = MathUtils.getAbsMax(x);
        float skipSizeInSeconds = TrackModifier.DEFAULT_MODIFICATION_SKIP_SIZE;
        boolean isVoicingAdaptiveTimeScaling = false;
        float timeScalingVoicingThreshold = 0.5f;
        boolean isVoicingAdaptivePitchScaling = false;
        int spectralEnvelopeType = 1;
        String envelopeName = "sv";
        int analyzerType = 2;
        int pitchMarkOffset = 0;
        int synthesizerType = 1;
        ProsodyModifier pm = new ProsodyModifier(samplingRate);
        double[] y = null;
        int sysPhaseModMethod = 3;
        int sysAmpModMethod = 2;
        pitchMarkOffset = n = 0;
        String pitchMarkOffsetStr = String.valueOf(pitchMarkOffset);
        if (n < 10) {
            pitchMarkOffsetStr = "0" + pitchMarkOffsetStr;
        }
        float timeScale = 1.0f;
        float pitchScale = 4.0f;
        y = pm.process(x, f0.contour, (float)f0.header.windowSizeInSeconds, (float)f0.header.skipSizeInSeconds, isVoicingAdaptiveTimeScaling, timeScalingVoicingThreshold, isVoicingAdaptivePitchScaling, timeScale, pitchScale, skipSizeInSeconds, deltaInHz, numPeriods, bRefinePeakEstimatesParabola, bRefinePeakEstimatesBias, bSpectralReassignment, bAdjustNeighFreqDependent, isSilentSynthesis, absMaxOriginal, spectralEnvelopeType, analyzerType, synthesizerType, pitchMarkOffset, sysPhaseModMethod, sysAmpModMethod);
        DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(y), inputAudio.getFormat());
        String outFileName = args[0].substring(0, args[0].length() - 4) + "_sin_t" + String.valueOf(timeScale) + "_p" + String.valueOf(pitchScale) + "_phaseMod" + String.valueOf(sysPhaseModMethod) + "_ampMod" + String.valueOf(sysAmpModMethod) + ".wav";
        AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
        System.out.println("Sinusoidal prosody modifications completed...");
    }
}

