/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.nio.charset.Charset;
import opennlp.tools.cmdline.CmdLineUtil;

public class BasicTrainingParameters {
    private final String language;
    private final Charset encoding;
    private final int iterations;
    private final int cutoff;

    public BasicTrainingParameters(String[] args) {
        this.encoding = CmdLineUtil.getEncodingParameter(args);
        this.language = CmdLineUtil.getParameter("-lang", args);
        CmdLineUtil.checkLanguageCode(this.language);
        Integer iterationsParameter = CmdLineUtil.getIntParameter("-iterations", args);
        this.iterations = iterationsParameter != null ? iterationsParameter : 100;
        Integer cutoffParameter = CmdLineUtil.getIntParameter("-cutoff", args);
        this.cutoff = cutoffParameter != null ? cutoffParameter : 5;
    }

    public String getLanguage() {
        return this.language;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public int getNumberOfIterations() {
        return this.iterations;
    }

    public int getCutoff() {
        return this.cutoff;
    }

    public boolean isValid() {
        return this.language != null && this.encoding != null;
    }

    public static String getParameterUsage() {
        return "-lang language -encoding charset [-iterations num] [-cutoff num]";
    }

    public static String getDescription() {
        return "-lang language     specifies the language which is being processed.\n-encoding charset  specifies the encoding which should be used for reading and writing text.\n-iterations num    specified the number of training iterations\n-cutoff num        specifies the min number of times a feature must be seen";
    }
}

