/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.lt.tools.tokenizer.annotate;

import de.dfki.lt.tools.tokenizer.annotate.AnnotatedString;
import java.util.HashMap;

public class FastAnnotatedString
implements AnnotatedString {
    private int index;
    private int endIndex;
    private char[] content;
    private HashMap annotations;
    private HashMap borders;
    private String currentKey;
    private Object[] currentValues;
    private boolean[] currentBorders;

    private FastAnnotatedString() {
    }

    public FastAnnotatedString(String anInputText) {
        if (anInputText == null) {
            throw new NullPointerException();
        }
        this.endIndex = anInputText.length();
        this.content = anInputText.toCharArray();
        this.annotations = new HashMap(5);
        this.borders = new HashMap(5);
        this.currentKey = null;
        this.currentBorders = null;
        this.currentValues = null;
        this.index = 0;
    }

    @Override
    public char first() {
        this.index = 0;
        return this.current();
    }

    @Override
    public char last() {
        this.index = 0 != this.endIndex ? this.endIndex - 1 : this.endIndex;
        return this.current();
    }

    @Override
    public char current() {
        if (this.index >= 0 && this.index < this.endIndex) {
            return this.content[this.index];
        }
        return '\uffff';
    }

    @Override
    public char next() {
        if (this.index < this.endIndex - 1) {
            ++this.index;
            return this.content[this.index];
        }
        this.index = this.endIndex;
        return '\uffff';
    }

    @Override
    public char previous() {
        if (this.index > 0) {
            --this.index;
            return this.content[this.index];
        }
        return '\uffff';
    }

    @Override
    public int getBeginIndex() {
        return 0;
    }

    @Override
    public int getEndIndex() {
        return this.endIndex;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public char setIndex(int anIndex) {
        if (anIndex < 0 || anIndex > this.endIndex) {
            throw new IllegalArgumentException("Invalid index");
        }
        this.index = anIndex;
        return this.current();
    }

    @Override
    public Object clone() {
        try {
            FastAnnotatedString other = (FastAnnotatedString)super.clone();
            return other;
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError();
        }
    }

    @Override
    public char charAt(int charIndex) {
        if (charIndex < 0 || charIndex > this.endIndex) {
            throw new IllegalArgumentException("Invalid index");
        }
        if (charIndex >= 0 && charIndex < this.endIndex) {
            return this.content[charIndex];
        }
        return '\uffff';
    }

    @Override
    public String substring(int aBeginIndex, int anEndIndex) {
        if (aBeginIndex < 0 || anEndIndex > this.endIndex || aBeginIndex > anEndIndex) {
            throw new IllegalArgumentException("Invalid substring range");
        }
        return new String(this.content, aBeginIndex, anEndIndex - aBeginIndex);
    }

    @Override
    public void annotate(String key, Object value, int aBeginIndex, int anEndIndex) {
        if (aBeginIndex < 0 || anEndIndex > this.endIndex || aBeginIndex >= anEndIndex) {
            throw new IllegalArgumentException("Invalid substring range");
        }
        if (!key.equals(this.currentKey)) {
            Object probe = this.annotations.get(key);
            if (null == probe) {
                this.currentValues = new Object[this.endIndex];
                this.currentBorders = new boolean[this.endIndex];
                this.currentKey = key;
                if (this.endIndex > 0) {
                    this.currentBorders[0] = true;
                }
                this.annotations.put(key, this.currentValues);
                this.borders.put(key, this.currentBorders);
            } else {
                this.currentValues = (Object[])probe;
                this.currentBorders = (boolean[])this.borders.get(key);
                this.currentKey = key;
            }
        }
        for (int i = aBeginIndex; i < anEndIndex; ++i) {
            this.currentValues[i] = value;
            this.currentBorders[i] = false;
        }
        this.currentBorders[aBeginIndex] = true;
        if (anEndIndex < this.endIndex) {
            this.currentBorders[anEndIndex] = true;
        }
    }

    @Override
    public Object getAnnotation(String key) {
        if (this.index >= 0 && this.index < this.endIndex) {
            if (!key.equals(this.currentKey)) {
                Object probe = this.annotations.get(key);
                if (null != probe) {
                    this.currentKey = key;
                    this.currentValues = (Object[])probe;
                    this.currentBorders = (boolean[])this.borders.get(key);
                } else {
                    return null;
                }
            }
            return this.currentValues[this.index];
        }
        return null;
    }

    @Override
    public int getRunStart(String key) {
        if (!key.equals(this.currentKey)) {
            Object probe = this.borders.get(key);
            if (null != probe) {
                this.currentKey = key;
                this.currentValues = (Object[])this.annotations.get(key);
                this.currentBorders = (boolean[])probe;
            } else {
                return 0;
            }
        }
        for (int i = this.index; i >= 0; --i) {
            if (!this.currentBorders[i]) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int getRunLimit(String key) {
        if (!key.equals(this.currentKey)) {
            Object probe = this.borders.get(key);
            if (null != probe) {
                this.currentKey = key;
                this.currentValues = (Object[])this.annotations.get(key);
                this.currentBorders = (boolean[])probe;
            } else {
                return this.endIndex;
            }
        }
        for (int i = this.index + 1; i < this.endIndex; ++i) {
            if (!this.currentBorders[i]) continue;
            return i;
        }
        return this.endIndex;
    }

    @Override
    public int findNextAnnotation(String key) {
        if (!key.equals(this.currentKey)) {
            Object probe = this.annotations.get(key);
            if (null != probe) {
                this.currentKey = key;
                this.currentValues = (Object[])probe;
                this.currentBorders = (boolean[])this.borders.get(key);
            } else {
                return this.endIndex;
            }
        }
        for (int i = this.index + 1; i < this.endIndex; ++i) {
            if (!this.currentBorders[i]) continue;
            for (int j = i; j < this.endIndex; ++j) {
                if (null == this.currentValues[j]) continue;
                return j;
            }
            return this.endIndex;
        }
        return this.endIndex;
    }

    @Override
    public String toString(String key) {
        StringBuffer result = new StringBuffer();
        int bakupIndex = this.index;
        this.index = 0;
        while (this.index < this.endIndex) {
            int endAnno = this.getRunLimit(key);
            if (null != this.getAnnotation(key)) {
                result.append(this.substring(this.index, endAnno) + "\t" + this.index + "-" + endAnno + "\t" + this.getAnnotation(key) + System.getProperty("line.separator"));
            }
            this.index = endAnno;
        }
        this.index = bakupIndex;
        return result.toString();
    }

    @Override
    public String toString() {
        return new String(this.content);
    }
}

