/*
 * Decompiled with CFR 0.152.
 */
package marytts.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.Version;
import marytts.config.LanguageConfig;
import marytts.config.MaryConfig;
import marytts.datatypes.MaryDataType;
import marytts.htsengine.HMMVoice;
import marytts.modules.synthesis.Voice;
import marytts.server.MaryProperties;
import marytts.server.Request;
import marytts.server.RequestHandler;
import marytts.signalproc.effects.AudioEffect;
import marytts.signalproc.effects.AudioEffects;
import marytts.signalproc.effects.BaseAudioEffect;
import marytts.unitselection.UnitSelectionVoice;
import marytts.unitselection.interpolation.InterpolatingVoice;
import marytts.util.MaryRuntimeUtils;
import marytts.util.MaryUtils;
import marytts.util.data.audio.MaryAudioUtils;
import org.apache.log4j.Logger;

public class MaryServer
implements Runnable {
    private ServerSocket server;
    private Logger logger;
    private int runningNumber = 1;
    private Map<Integer, Object[]> clientMap = Collections.synchronizedMap(new HashMap());
    private Executor clients = Executors.newCachedThreadPool();

    public MaryServer() {
        this.logger = MaryUtils.getLogger("server");
    }

    @Override
    public void run() {
        this.logger.info("Starting server.");
        try {
            this.server = new ServerSocket(MaryProperties.needInteger("socket.port"));
            while (true) {
                this.logger.info("Waiting for client to connect on port " + this.server.getLocalPort());
                Socket client = this.server.accept();
                this.logger.info("Connection from " + client.getInetAddress().getHostName() + " (" + client.getInetAddress().getHostAddress() + ").");
                this.clients.execute(new ClientHandler(client));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized int getID() {
        return this.runningNumber++;
    }

    public class ClientHandler
    implements Runnable {
        Socket client;
        PrintWriter clientOut;

        public ClientHandler(Socket client) throws IOException {
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MaryServer.this.logger = MaryUtils.getLogger("server");
            try {
                OutputStreamWriter clientUTFOutput = new OutputStreamWriter(this.client.getOutputStream(), "UTF-8");
                this.clientOut = new PrintWriter((Writer)clientUTFOutput, true);
                this.handle();
            }
            catch (UnsupportedEncodingException ex) {
                throw new AssertionError((Object)"UTF-8 is always a supported encoding.");
            }
            catch (Exception e) {
                MaryServer.this.logger.info("Error parsing request:", e);
                if (this.clientOut == null) {
                    MaryServer.this.logger.info("Cannot write to client.");
                } else {
                    this.clientOut.println("Error parsing request:");
                    this.clientOut.println(e.getMessage());
                }
            }
        }

        private void handle() throws Exception {
            BufferedReader buffReader = new BufferedReader(new InputStreamReader(this.client.getInputStream(), "UTF-8"));
            String line = buffReader.readLine();
            MaryServer.this.logger.debug("read request: `" + line + "'");
            if (line == null) {
                MaryServer.this.logger.info("Client seems to have disconnected - cannot read.");
                return;
            }
            while (this.handleInfoRequest(line)) {
                line = buffReader.readLine();
                if (line != null) continue;
                return;
            }
            if (this.handleSynthesisRequest(line)) {
                return;
            }
            if (this.handleNumberRequest(line, buffReader)) {
                return;
            }
            String nl = System.getProperty("line.separator");
            throw new Exception("Expected either a line" + nl + "MARY IN=<INPUTTYPE> OUT=<OUTPUTTYPE> [AUDIO=<AUDIOTYPE>]" + nl + "or a line containing only a number identifying a request.");
        }

        private boolean handleInfoRequest(String inputLine) {
            if (inputLine.startsWith("MARY VERSION")) {
                MaryServer.this.logger.debug("InfoRequest " + inputLine);
                return this.handleVersion();
            }
            if (inputLine.startsWith("MARY LIST DATATYPES")) {
                MaryServer.this.logger.debug("InfoRequest " + inputLine);
                return this.listDataTypes();
            }
            if (inputLine.startsWith("MARY LIST LOCALES")) {
                MaryServer.this.logger.debug("InfoRequest " + inputLine);
                return this.listLocales();
            }
            if (inputLine.startsWith("MARY LIST VOICES")) {
                MaryServer.this.logger.debug("InfoRequest " + inputLine);
                return this.listVoices();
            }
            if (inputLine.startsWith("MARY LIST AUDIOFILEFORMATTYPES")) {
                MaryServer.this.logger.debug("InfoRequest " + inputLine);
                return this.listAudioFileFormatTypes();
            }
            if (inputLine.startsWith("MARY EXAMPLETEXT")) {
                MaryServer.this.logger.debug("InfoRequest " + inputLine);
                return this.exampleText(inputLine);
            }
            if (inputLine.startsWith("MARY VOICE EXAMPLETEXT")) {
                MaryServer.this.logger.debug("InfoRequest " + inputLine);
                return this.voiceExampleText(inputLine);
            }
            if (inputLine.startsWith("MARY VOICE GETDEFAULTAUDIOEFFECTS")) {
                MaryServer.this.logger.debug("InfoRequest " + inputLine);
                return this.voiceGetDefaultAudioEffects(inputLine);
            }
            if (inputLine.startsWith("MARY VOICE GETAUDIOEFFECTHELPTEXTLINEBREAK")) {
                MaryServer.this.logger.debug("InfoRequest " + inputLine);
                return this.voiceGetAudioEffectHelpTextLineBreak();
            }
            if (inputLine.startsWith("MARY VOICE GETAUDIOEFFECTDEFAULTPARAM ")) {
                return this.getAudioEffectDefaultParameters(inputLine);
            }
            if (inputLine.startsWith("MARY VOICE GETFULLAUDIOEFFECT ")) {
                return this.voiceGetFullAudioEffect(inputLine);
            }
            if (inputLine.startsWith("MARY VOICE GETAUDIOEFFECTHELPTEXT ")) {
                return this.getAudioEffectHelpText(inputLine);
            }
            if (inputLine.startsWith("MARY VOICE ISHMMAUDIOEFFECT ")) {
                return this.isHMMAudioEffect(inputLine);
            }
            return false;
        }

        private boolean handleSynthesisRequest(String inputLine) throws Exception {
            int id = 0;
            if (!inputLine.startsWith("MARY")) {
                return false;
            }
            StringTokenizer t = new StringTokenizer(inputLine);
            if (t.hasMoreTokens()) {
                t.nextToken();
            }
            MaryDataType inputType = this.parseSynthesisRequiredInputType(t);
            MaryDataType outputType = this.parseSynthesisRequiredOutputType(t);
            Locale locale = this.parseSynthesisRequiredLocale(t);
            AudioFileFormat.Type audioFileFormatType = null;
            boolean streamingAudio = false;
            Voice voice = null;
            String style = null;
            String effects = null;
            while (t.hasMoreTokens()) {
                String token = t.nextToken();
                if (token.startsWith("AUDIO")) {
                    String audio = this.parseProtocolParameter(token, "AUDIO", "AUDIOTYPE");
                    streamingAudio = audio.startsWith("STREAMING_");
                    if (outputType != MaryDataType.get("AUDIO")) continue;
                    if (streamingAudio) {
                        audioFileFormatType = MaryAudioUtils.getAudioFileFormatType(audio.substring(10));
                        continue;
                    }
                    audioFileFormatType = MaryAudioUtils.getAudioFileFormatType(audio);
                    continue;
                }
                if (token.startsWith("VOICE")) {
                    voice = this.parseSynthesisVoiceType(token, locale);
                    continue;
                }
                if (token.startsWith("STYLE")) {
                    style = this.parseProtocolParameter(token, "STYLE", "STYLE_NAME");
                    continue;
                }
                if (token.startsWith("EFFECTS")) {
                    effects = this.parseProtocolParameter(token, "EFFECTS", "EFFECTS_LIST");
                    continue;
                }
                if (!token.startsWith("LOG")) continue;
                this.parseSynthesisLog(token, t);
            }
            if (audioFileFormatType == null) {
                audioFileFormatType = AudioFileFormat.Type.WAVE;
            }
            if (voice == null) {
                voice = Voice.getDefaultVoice(locale);
                MaryServer.this.logger.debug("No voice requested -- using default " + voice);
            }
            if (style == null) {
                MaryServer.this.logger.debug("No style requested");
            } else {
                MaryServer.this.logger.debug("Style requested: " + style);
            }
            if (effects == null) {
                MaryServer.this.logger.debug("No audio effects requested");
            } else {
                MaryServer.this.logger.debug("Audio effects requested: " + effects);
            }
            id = MaryServer.this.getID();
            AudioFormat audioFormat = voice.dbAudioFormat();
            if (audioFileFormatType.toString().equals("MP3")) {
                if (!MaryRuntimeUtils.canCreateMP3()) {
                    throw new UnsupportedAudioFileException("Conversion to MP3 not supported.");
                }
                audioFormat = MaryRuntimeUtils.getMP3AudioFormat();
            } else if (audioFileFormatType.toString().equals("Vorbis")) {
                if (!MaryRuntimeUtils.canCreateOgg()) {
                    throw new UnsupportedAudioFileException("Conversion to OGG Vorbis format not supported.");
                }
                audioFormat = MaryRuntimeUtils.getOggAudioFormat();
            }
            AudioFileFormat audioFileFormat = new AudioFileFormat(audioFileFormatType, audioFormat, -1);
            Request request = new Request(inputType, outputType, locale, voice, effects, style, id, audioFileFormat, streamingAudio, null);
            this.clientOut.println(id);
            Object[] value = new Object[]{this.client, request};
            MaryServer.this.clientMap.put(id, value);
            return true;
        }

        private String parseProtocolParameter(String token, String expectedParameterType, String parameterDescription) throws Exception {
            StringTokenizer tt = new StringTokenizer(token, "=");
            if (tt.countTokens() != 2 || !tt.nextToken().equals(expectedParameterType)) {
                throw new Exception("Expected " + expectedParameterType + "=<" + parameterDescription + ">");
            }
            return tt.nextToken();
        }

        private void parseSynthesisLog(String token, StringTokenizer t) throws Exception {
            String log = this.parseProtocolParameter(token, "LOG", "LOG_INPUT");
            while (t.hasMoreTokens()) {
                log = log + " " + t.nextToken();
            }
            MaryServer.this.logger.info("Connection info: " + log);
        }

        private Voice parseSynthesisVoiceType(String t, Locale locale) throws Exception {
            String voiceName = this.parseProtocolParameter(t, "VOICE", "VOICE_NAME_OR_GENDER");
            if ((voiceName.equals("male") || voiceName.equals("female")) && locale != null) {
                return Voice.getVoice(locale, new Voice.Gender(voiceName));
            }
            return Voice.getVoice(voiceName);
        }

        private MaryDataType parseSynthesisRequiredInputType(StringTokenizer t) throws Exception {
            if (!t.hasMoreTokens()) {
                throw new Exception("Expected IN=<INPUTTYPE>");
            }
            String input = this.parseProtocolParameter(t.nextToken(), "IN", "INPUTTYPE");
            MaryDataType inputType = MaryDataType.get(input);
            if (inputType == null) {
                throw new Exception("Invalid input type: " + input);
            }
            return inputType;
        }

        private MaryDataType parseSynthesisRequiredOutputType(StringTokenizer t) throws Exception {
            if (!t.hasMoreTokens()) {
                throw new Exception("Expected OUT=<OUTPUTTYPE>");
            }
            String output = this.parseProtocolParameter(t.nextToken(), "OUT", "OUTPUTTYPE");
            MaryDataType outputType = MaryDataType.get(output);
            if (outputType == null) {
                throw new Exception("Invalid output type: " + output);
            }
            return outputType;
        }

        private Locale parseSynthesisRequiredLocale(StringTokenizer t) throws Exception {
            if (!t.hasMoreTokens()) {
                throw new Exception("Expected LOCALE=<locale>");
            }
            String localeString = this.parseProtocolParameter(t.nextToken(), "LOCALE", "locale");
            return MaryUtils.string2locale(localeString);
        }

        private boolean handleNumberRequest(String inputLine, Reader reader) throws Exception {
            int id = 0;
            try {
                id = Integer.parseInt(inputLine);
            }
            catch (NumberFormatException e) {
                return false;
            }
            Socket infoSocket = null;
            Request request = null;
            long TIMEOUT = 1000L;
            long startTime = System.currentTimeMillis();
            Object[] value = null;
            do {
                Thread.yield();
            } while ((value = (Object[])MaryServer.this.clientMap.get(id)) == null && System.currentTimeMillis() - startTime < TIMEOUT);
            if (value != null) {
                infoSocket = (Socket)value[0];
                request = (Request)value[1];
            }
            if (request == null || infoSocket == null || !infoSocket.getInetAddress().equals(this.client.getInetAddress())) {
                throw new Exception("Invalid identification number.");
            }
            try {
                MaryServer.this.clientMap.remove(id);
            }
            catch (UnsupportedOperationException e) {
                MaryServer.this.logger.info("Cannot remove clientMap entry", e);
            }
            RequestHandler rh = new RequestHandler(request, infoSocket, this.client, reader);
            rh.start();
            return true;
        }

        private boolean handleVersion() {
            this.clientOut.println("Mary TTS server " + Version.specificationVersion() + " (impl. " + Version.implementationVersion() + ")");
            this.clientOut.println();
            return true;
        }

        private boolean isHMMAudioEffect(String inputLine) {
            String prefix = "MARY VOICE ISHMMAUDIOEFFECT ";
            assert (inputLine.startsWith(prefix));
            String effectName = inputLine.substring(prefix.length());
            AudioEffect effect = AudioEffects.getEffect(effectName);
            if (effect == null) {
                return false;
            }
            MaryServer.this.logger.debug("InfoRequest " + inputLine);
            this.clientOut.println(effect.isHMMEffect() ? "yes" : "no");
            this.clientOut.println();
            return true;
        }

        private boolean listAudioFileFormatTypes() {
            String info = MaryRuntimeUtils.getAudioFileFormatTypes();
            this.clientOut.println(info);
            this.clientOut.println();
            return true;
        }

        private boolean listDataTypes() {
            for (MaryDataType t : MaryDataType.getDataTypes()) {
                this.clientOut.print(t.name());
                if (t.isInputType()) {
                    this.clientOut.print(" INPUT");
                }
                if (t.isOutputType()) {
                    this.clientOut.print(" OUTPUT");
                }
                this.clientOut.println();
            }
            this.clientOut.println();
            return true;
        }

        private boolean listLocales() {
            StringBuilder out = new StringBuilder();
            for (LanguageConfig conf : MaryConfig.getLanguageConfigs()) {
                for (Locale locale : conf.getLocales()) {
                    out.append(locale).append('\n');
                }
            }
            this.clientOut.print(out.toString());
            this.clientOut.println();
            return true;
        }

        private boolean listVoices() {
            for (Voice v : Voice.getAvailableVoices()) {
                if (v instanceof InterpolatingVoice) continue;
                if (v instanceof UnitSelectionVoice) {
                    this.clientOut.println(v.getName() + " " + v.getLocale() + " " + v.gender().toString() + " " + "unitselection" + " " + ((UnitSelectionVoice)v).getDomain());
                    continue;
                }
                if (v instanceof HMMVoice) {
                    this.clientOut.println(v.getName() + " " + v.getLocale() + " " + v.gender().toString() + " " + "hmm");
                    continue;
                }
                this.clientOut.println(v.getName() + " " + v.getLocale() + " " + v.gender().toString() + " " + "other");
            }
            this.clientOut.println();
            return true;
        }

        private boolean exampleText(String inputLine) {
            StringTokenizer st = new StringTokenizer(inputLine);
            st.nextToken();
            st.nextToken();
            try {
                String typeName = st.nextToken();
                Locale locale = MaryUtils.string2locale(st.nextToken());
                MaryDataType type = MaryDataType.get(typeName);
                String exampleText = type.exampleText(locale);
                if (exampleText != null) {
                    this.clientOut.println(exampleText.trim());
                }
            }
            catch (NullPointerException err) {
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.clientOut.println();
            return true;
        }

        private boolean voiceExampleText(String inputLine) {
            StringTokenizer st = new StringTokenizer(inputLine);
            st.nextToken();
            st.nextToken();
            st.nextToken();
            try {
                String voiceName = st.nextToken();
                Voice v = Voice.getVoice(voiceName);
                String text = ((UnitSelectionVoice)v).getExampleText();
                if (text != null) {
                    this.clientOut.println(text);
                }
            }
            catch (NullPointerException err) {
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.clientOut.println();
            return true;
        }

        private boolean voiceGetAudioEffectHelpTextLineBreak() {
            this.clientOut.println(BaseAudioEffect.strLineBreak);
            this.clientOut.println();
            return true;
        }

        private boolean voiceGetDefaultAudioEffects(String inputLine) {
            StringBuilder sb = new StringBuilder();
            for (AudioEffect effect : AudioEffects.getEffects()) {
                sb.append(effect.getName()).append(" ").append(effect.getExampleParameters()).append("\n");
            }
            this.clientOut.println(sb.toString());
            this.clientOut.println();
            return true;
        }

        private boolean getAudioEffectDefaultParameters(String inputLine) {
            String prefix = "MARY VOICE GETAUDIOEFFECTDEFAULTPARAM ";
            assert (inputLine.startsWith(prefix));
            String effectName = inputLine.substring(prefix.length()).trim();
            AudioEffect effect = AudioEffects.getEffect(effectName);
            if (effect == null) {
                return false;
            }
            this.clientOut.println(effect.getExampleParameters().trim());
            this.clientOut.println();
            return true;
        }

        private boolean voiceGetFullAudioEffect(String inputLine) {
            AudioEffect effect;
            String prefix = "MARY VOICE GETFULLAUDIOEFFECT ";
            assert (inputLine.startsWith(prefix));
            String effectPlusParams = inputLine.substring(prefix.length()).trim();
            String[] parts = effectPlusParams.split("\\s", 2);
            String effectName = parts[0];
            String params = "";
            if (parts.length > 1) {
                params = parts[1];
            }
            if ((effect = AudioEffects.getEffect(effectName)) == null) {
                MaryServer.this.logger.error("Effect name missing in request!");
                return false;
            }
            MaryServer.this.logger.debug("InfoRequest " + inputLine);
            effect.setParams(params);
            this.clientOut.println(effect.getFullEffectAsString());
            this.clientOut.println();
            return true;
        }

        private boolean getAudioEffectHelpText(String inputLine) {
            String prefix = "MARY VOICE GETAUDIOEFFECTHELPTEXT ";
            assert (inputLine.startsWith(prefix));
            String effectName = inputLine.substring(prefix.length());
            AudioEffect effect = AudioEffects.getEffect(effectName);
            if (effect == null) {
                return false;
            }
            this.clientOut.println(effect.getHelpText().trim());
            this.clientOut.println();
            return true;
        }
    }
}

