/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.dom;

import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import marytts.exceptions.MaryConfigurationException;
import marytts.util.MaryUtils;
import marytts.util.io.ReaderSplitter;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class MaryNormalisedWriter {
    private static TransformerFactory tFactory = null;
    private static Templates stylesheet = null;
    private static Logger logger;
    private Transformer transformer;

    public MaryNormalisedWriter() throws MaryConfigurationException {
        try {
            MaryNormalisedWriter.startup();
            this.transformer = stylesheet.newTransformer();
        }
        catch (Exception e) {
            throw new MaryConfigurationException("Cannot initialise XML writing code", e);
        }
    }

    private static void startup() throws TransformerFactoryConfigurationError, TransformerConfigurationException {
        if (tFactory == null) {
            tFactory = TransformerFactory.newInstance();
        }
        if (stylesheet == null) {
            StreamSource stylesheetStream = new StreamSource(MaryNormalisedWriter.class.getResourceAsStream("normalise-maryxml.xsl"));
            stylesheet = tFactory.newTemplates(stylesheetStream);
        }
        if (logger == null) {
            logger = MaryUtils.getLogger("MaryNormalisedWriter");
        }
    }

    public void output(Source input, Result destination) throws TransformerException {
        this.transformer.transform(input, destination);
    }

    public void output(Source input) throws TransformerException {
        this.output(input, new StreamResult(new PrintStream(System.out, true)));
    }

    public void output(Node input) throws TransformerException {
        this.output(new DOMSource(input));
    }

    public void output(Node input, OutputStream destination) throws TransformerException {
        this.output(new DOMSource(input), new StreamResult(destination));
    }

    public static void main(String[] args) throws Throwable {
        MaryNormalisedWriter.startup();
        MaryNormalisedWriter writer = new MaryNormalisedWriter();
        ReaderSplitter splitter = new ReaderSplitter(new InputStreamReader(System.in), "</maryxml>");
        Reader oneXMLStructure = null;
        while ((oneXMLStructure = splitter.nextReader()) != null) {
            writer.output(new StreamSource(oneXMLStructure));
        }
    }
}

