/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import java.io.IOException;
import opennlp.maxent.GISModel;
import opennlp.maxent.GISTrainer;
import opennlp.model.DataIndexer;
import opennlp.model.EventStream;
import opennlp.model.Prior;

public class GIS {
    public static boolean PRINT_MESSAGES = true;
    public static double SMOOTHING_OBSERVATION = 0.1;

    public static GISModel trainModel(EventStream eventStream) throws IOException {
        return GIS.trainModel(eventStream, 100, 0, false, PRINT_MESSAGES);
    }

    public static GISModel trainModel(EventStream eventStream, boolean smoothing) throws IOException {
        return GIS.trainModel(eventStream, 100, 0, smoothing, PRINT_MESSAGES);
    }

    public static GISModel trainModel(EventStream eventStream, int iterations, int cutoff) throws IOException {
        return GIS.trainModel(eventStream, iterations, cutoff, false, PRINT_MESSAGES);
    }

    public static GISModel trainModel(EventStream eventStream, int iterations, int cutoff, boolean smoothing, boolean printMessagesWhileTraining) throws IOException {
        GISTrainer trainer = new GISTrainer(printMessagesWhileTraining);
        trainer.setSmoothing(smoothing);
        trainer.setSmoothingObservation(SMOOTHING_OBSERVATION);
        return trainer.trainModel(eventStream, iterations, cutoff);
    }

    public static GISModel trainModel(EventStream eventStream, int iterations, int cutoff, double sigma) throws IOException {
        GISTrainer trainer = new GISTrainer(PRINT_MESSAGES);
        if (sigma > 0.0) {
            trainer.setGaussianSigma(sigma);
        }
        return trainer.trainModel(eventStream, iterations, cutoff);
    }

    public static GISModel trainModel(int iterations, DataIndexer indexer, boolean smoothing) {
        return GIS.trainModel(iterations, indexer, true, smoothing, null, 0);
    }

    public static GISModel trainModel(int iterations, DataIndexer indexer) {
        return GIS.trainModel(iterations, indexer, true, false, null, 0);
    }

    public static GISModel trainModel(int iterations, DataIndexer indexer, Prior modelPrior, int cutoff) {
        return GIS.trainModel(iterations, indexer, true, false, modelPrior, cutoff);
    }

    public static GISModel trainModel(int iterations, DataIndexer indexer, boolean printMessagesWhileTraining, boolean smoothing, Prior modelPrior, int cutoff) {
        GISTrainer trainer = new GISTrainer(printMessagesWhileTraining);
        trainer.setSmoothing(smoothing);
        trainer.setSmoothingObservation(SMOOTHING_OBSERVATION);
        if (modelPrior != null) {
            return trainer.trainModel(iterations, indexer, modelPrior, cutoff);
        }
        return trainer.trainModel(iterations, indexer, cutoff);
    }
}

