/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer;

import com.rapidminer.BreakpointListener;
import com.rapidminer.Process;
import com.rapidminer.RapidMiner;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.Tools;
import java.io.File;
import java.io.IOException;

public class RapidMinerCommandLine
extends RapidMiner
implements BreakpointListener {
    private static final String LICENSE = "RapidMiner version " + RapidMiner.getLongVersion() + ", Copyright (C) 2001-2008" + Tools.getLineSeparator() + "RapidMiner comes with ABSOLUTELY NO WARRANTY; This is free software," + Tools.getLineSeparator() + "and you are welcome to redistribute it under certain conditions;" + Tools.getLineSeparator() + "see license information in the file named LICENSE.";
    private boolean showLogo = false;
    private String processFile = null;

    public void breakpointReached(Process process, Operator operator, IOContainer container, int location) {
        System.out.println("Results in application " + operator.getApplyCount() + " of " + operator.getName() + ":" + Tools.getLineSeparator() + container);
        System.out.println("Breakpoint reached " + (location == 0 ? "before " : "after ") + operator.getName() + ", press enter...");
        new WaitForKeyThread(process).start();
    }

    public void resume() {
    }

    private void parseArguments(String[] argv) {
        this.processFile = null;
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-l")) {
                this.showLogo = true;
            } else {
                this.processFile = argv[i];
            }
            ++i;
        }
        if (this.processFile == null) {
            RapidMinerCommandLine.printUsage();
        }
    }

    private static void printUsage() {
        System.err.println("Usage: " + RapidMinerCommandLine.class.getName() + " PROCESSFILE");
        System.exit(1);
    }

    private void run() {
        ParameterService.ensureRapidMinerHomeSet();
        if (this.showLogo) {
            RapidMiner.showSplash();
        }
        if (this.showLogo) {
            RapidMiner.hideSplash();
        }
        RapidMiner.init();
        Process process = null;
        try {
            process = RapidMiner.readProcessFile(new File(this.processFile));
        }
        catch (Exception e) {
            System.err.println("ERROR: Cannot read process setup '" + this.processFile + "'...");
            RapidMiner.quit(1);
        }
        if (process != null) {
            try {
                process.addBreakpointListener(this);
                IOContainer results = process.run();
                process.getRootOperator().sendEmail(results, null);
                System.out.println("Process finished successfully");
                RapidMiner.quit(0);
            }
            catch (Throwable e) {
                String debugProperty = System.getProperty("rapidminer.general.debugmode");
                boolean debugMode = Tools.booleanValue(debugProperty, false);
                String message = e.getMessage();
                if (!debugMode && e instanceof RuntimeException) {
                    message = e.getMessage() != null ? "operator cannot be executed (" + e.getMessage() + "). Check the log messages..." : "operator cannot be executed. Check the log messages...";
                }
                process.getLog().logFinalException("Process failed: " + message, process, e, debugMode);
                try {
                    process.getRootOperator().sendEmail(null, e);
                }
                catch (UndefinedParameterError undefinedParameterError) {
                    // empty catch block
                }
                System.err.println("Process not successful");
                RapidMiner.quit(1);
            }
        }
    }

    public static void main(String[] argv) {
        System.out.println(LICENSE);
        RapidMinerCommandLine main = new RapidMinerCommandLine();
        main.parseArguments(argv);
        main.run();
    }

    private class WaitForKeyThread
    extends Thread {
        private Process process;

        public WaitForKeyThread(Process process) {
            this.process = process;
        }

        public void run() {
            try {
                System.in.read();
            }
            catch (IOException e) {
                System.err.println("Error occured: " + e.getMessage());
            }
            this.process.resume();
        }
    }
}

