/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look;

import com.rapidminer.gui.look.TextActions;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;

public class ClipboardActionsPopup
extends JPopupMenu {
    private static final long serialVersionUID = -6304527692064490218L;
    private JTextComponent parent;
    private JMenuItem cutMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem pasteMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem clearMenuItem;
    private JMenuItem selectAllMenuItem;

    public ClipboardActionsPopup(JTextComponent parent) {
        this.parent = parent;
        this.cutMenuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        this.cutMenuItem.setText("Cut");
        this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.copyMenuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.pasteMenuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        this.pasteMenuItem.setText("Paste");
        this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.deleteMenuItem = new JMenuItem(new TextActions.DeleteTextAction());
        this.clearMenuItem = new JMenuItem(new TextActions.ClearAction());
        this.selectAllMenuItem = new JMenuItem(new TextActions.SelectAllAction());
        this.selectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.add(this.cutMenuItem);
        this.add(this.copyMenuItem);
        this.add(this.pasteMenuItem);
        this.add(this.deleteMenuItem);
        this.addSeparator();
        this.add(this.clearMenuItem);
        this.add(this.selectAllMenuItem);
        this.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth() + 30, (int)this.getPreferredSize().getHeight()));
    }

    protected final JTextComponent getTextComponent(Component c) {
        if (c != null && c instanceof JTextComponent) {
            return (JTextComponent)c;
        }
        return null;
    }

    public void show(Component invoker, int x, int y) {
        JTextComponent target = this.getTextComponent(invoker);
        if (target == null) {
            return;
        }
        if (target instanceof JPasswordField) {
            this.copyMenuItem.setEnabled(false);
            this.cutMenuItem.setEnabled(false);
        } else {
            if (target.getSelectionStart() != target.getSelectionEnd()) {
                this.copyMenuItem.setEnabled(true);
            } else {
                this.copyMenuItem.setEnabled(false);
            }
            if (target.getSelectionStart() != target.getSelectionEnd() && target.isEditable()) {
                this.cutMenuItem.setEnabled(true);
            } else {
                this.cutMenuItem.setEnabled(false);
            }
        }
        if (target.isEditable()) {
            this.pasteMenuItem.setEnabled(true);
        } else {
            this.pasteMenuItem.setEnabled(false);
        }
        if (target.isEditable() && target.getSelectionStart() != target.getSelectionEnd()) {
            this.deleteMenuItem.setEnabled(true);
        } else {
            this.deleteMenuItem.setEnabled(false);
        }
        if (this.getTextLength(target) > 0) {
            this.selectAllMenuItem.setEnabled(true);
        } else {
            this.selectAllMenuItem.setEnabled(false);
        }
        if (this.getTextLength(target) > 0 && target.isEditable()) {
            this.clearMenuItem.setEnabled(true);
        } else {
            this.clearMenuItem.setEnabled(false);
        }
        super.show(invoker, x, y);
        this.parent.requestFocus();
    }

    private int getTextLength(JTextComponent c) {
        if (c == null) {
            return 0;
        }
        if (c.getText() == null) {
            return 0;
        }
        return c.getText().length();
    }

    public void setVisible(boolean val) {
        try {
            super.setVisible(val);
            this.parent.requestFocus();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

