/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.gui.viewer.ROCChartPlotter;
import com.rapidminer.report.Renderable;
import com.rapidminer.tools.math.ROCData;
import com.rapidminer.tools.math.ROCDataGenerator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROCViewer
extends JPanel
implements Renderable {
    private static final long serialVersionUID = -5441366103559588567L;
    private ROCChartPlotter plotter;

    public ROCViewer(String message, ROCDataGenerator rocGenerator, List<ROCData> rocData) {
        this.setLayout(new BorderLayout());
        JPanel infoPanel = new JPanel(new FlowLayout(0));
        JTextPane infoText = new JTextPane();
        infoText.setEditable(false);
        infoText.setBackground(infoPanel.getBackground());
        infoText.setFont(infoText.getFont().deriveFont(1));
        infoText.setText(message);
        infoPanel.add(infoText);
        infoPanel.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)infoPanel, "North");
        this.plotter = new ROCChartPlotter();
        this.plotter.addROCData("ROC", rocData);
        this.add((Component)this.plotter, "Center");
    }

    @Override
    public void prepareRendering() {
        this.plotter.prepareRendering();
    }

    @Override
    public void finishRendering() {
        this.plotter.finishRendering();
    }

    @Override
    public int getRenderHeight(int preferredHeight) {
        return this.plotter.getRenderHeight(preferredHeight);
    }

    @Override
    public int getRenderWidth(int preferredWidth) {
        return this.plotter.getRenderWidth(preferredWidth);
    }

    @Override
    public void render(Graphics graphics, int width, int height) {
        this.plotter.render(graphics, width, height);
    }
}

