/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessLog2AttributeWeights
extends Operator {
    public static final String PARAMETER_LOG_NAME = "log_name";
    public static final String PARAMETER_ATTRIBUTE_NAMES_COLUMN = "attribute_names_column";
    public static final String PARAMETER_SORTING_TYPE = "sorting_type";
    public static final String PARAMETER_SORTING_DIMENSION = "sorting_dimension";
    public static final String PARAMETER_SORTING_K = "sorting_k";
    public static final String[] SORTING_TYPES = new String[]{"none", "top-k", "bottom-k"};
    public static final int SORTING_TYPE_NONE = 0;
    public static final int SORTING_TYPE_TOP_K = 1;
    public static final int SORTING_TYPE_BOTTOM_K = 2;

    public ProcessLog2AttributeWeights(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        Collection<DataTable> dataTables = this.getProcess().getDataTables();
        if (dataTables.size() == 0) {
            throw new UserError(this, 937);
        }
        DataTable dataTable = null;
        if (this.isParameterSet(PARAMETER_LOG_NAME)) {
            String dataTableName = this.getParameterAsString(PARAMETER_LOG_NAME);
            dataTable = this.getProcess().getDataTable(dataTableName);
        } else if (this.getProcess().getDataTables().size() > 0) {
            dataTable = this.getProcess().getDataTables().iterator().next();
            this.logNote("No log name was specified, using first data table found...");
        }
        String attributeNamesColumnName = this.getParameterAsString(PARAMETER_ATTRIBUTE_NAMES_COLUMN);
        int attributeNamesIndex = -1;
        int index = 0;
        String[] stringArray = dataTable.getColumnNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals(attributeNamesColumnName)) {
                attributeNamesIndex = index;
                break;
            }
            ++index;
            ++n2;
        }
        if (attributeNamesIndex < 0) {
            throw new UserError((Operator)this, 207, attributeNamesColumnName, PARAMETER_ATTRIBUTE_NAMES_COLUMN, "no column with this name is part of the first found statistics data table");
        }
        String sortingDimensionName = null;
        int sortingK = 0;
        int sortingType = this.getParameterAsInt(PARAMETER_SORTING_TYPE);
        switch (sortingType) {
            case 1: {
                sortingDimensionName = this.getParameterAsString(PARAMETER_SORTING_DIMENSION);
                sortingK = this.getParameterAsInt(PARAMETER_SORTING_K);
                break;
            }
            case 2: {
                sortingDimensionName = this.getParameterAsString(PARAMETER_SORTING_DIMENSION);
                sortingK = this.getParameterAsInt(PARAMETER_SORTING_K);
                break;
            }
        }
        int sortingDimensionIndex = -1;
        if (sortingDimensionName != null) {
            index = 0;
            String[] stringArray2 = dataTable.getColumnNames();
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String name = stringArray2[n4];
                if (name.equals(sortingDimensionName)) {
                    sortingDimensionIndex = index;
                    break;
                }
                ++index;
                ++n4;
            }
            if (sortingDimensionIndex < 0) {
                throw new UserError((Operator)this, 207, sortingDimensionName, PARAMETER_SORTING_DIMENSION, "no column with this name is part of the first found statistics data table");
            }
            if (!dataTable.isNumerical(sortingDimensionIndex)) {
                throw new UserError((Operator)this, 207, sortingDimensionName, PARAMETER_SORTING_DIMENSION, "only numerical columns are allowed for the sorting dimension");
            }
        }
        AttributeWeights weights = this.calculateWeights(dataTable, attributeNamesIndex, sortingType, sortingDimensionIndex, sortingK);
        if (this.getParameterAsBoolean("normalize_weights")) {
            weights.normalize();
        }
        return new IOObject[]{weights};
    }

    private AttributeWeights calculateWeights(DataTable dataTable, int attributeNamesIndex, int sortingType, int sortingDimensionIndex, int sortingK) {
        String name;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class NamesAndPerformance
        implements Comparable<NamesAndPerformance> {
            String names;
            double performance;
            private final /* synthetic */ int val$sortingType;

            public NamesAndPerformance(String names, double performance, int n) {
                this.val$sortingType = n;
                this.names = names;
                this.performance = performance;
            }

            @Override
            public int compareTo(NamesAndPerformance o) {
                if (this.val$sortingType == 0) {
                    return 0;
                }
                if (this.val$sortingType == 1) {
                    return Double.compare(o.performance, this.performance);
                }
                return Double.compare(this.performance, o.performance);
            }
        }
        LinkedList<NamesAndPerformance> namesAndPerformances = new LinkedList<NamesAndPerformance>();
        int i = 0;
        while (i < dataTable.getNumberOfRows()) {
            DataTableRow row = dataTable.getRow(i);
            String names = dataTable.getValueAsString(row, attributeNamesIndex);
            double performance = 1.0;
            if (sortingDimensionIndex >= 0) {
                performance = row.getValue(sortingDimensionIndex);
            }
            namesAndPerformances.add(new NamesAndPerformance(names, performance, sortingType));
            ++i;
        }
        Collections.sort(namesAndPerformances);
        HashMap<String, AtomicInteger> counters = new HashMap<String, AtomicInteger>();
        int number = 0;
        for (NamesAndPerformance namesAndPerformance : namesAndPerformances) {
            String[] names;
            if (sortingType != 0 && number >= sortingK) break;
            String[] stringArray = names = namesAndPerformance.names.split(",");
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                name = stringArray[n2];
                AtomicInteger counter = (AtomicInteger)counters.get(name = name.trim());
                if (counter == null) {
                    counter = new AtomicInteger(1);
                    counters.put(name, counter);
                } else {
                    counter.incrementAndGet();
                }
                ++n2;
            }
            ++number;
        }
        AttributeWeights weights = new AttributeWeights();
        for (Map.Entry entry : counters.entrySet()) {
            name = (String)entry.getKey();
            int currentCount = ((AtomicInteger)entry.getValue()).intValue();
            weights.setWeight(name, (double)currentCount / (double)number);
        }
        return weights;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{AttributeWeights.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("normalize_weights", "Activates the normalization of all weights.", true));
        types.add(new ParameterTypeString(PARAMETER_LOG_NAME, "The name of the ProcessLog operator which generated the log data which should be transformed (empty: use first found data table).", true));
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE_NAMES_COLUMN, "The column of the statistics (Process Log) containing the attribute names.", false));
        types.add(new ParameterTypeCategory(PARAMETER_SORTING_TYPE, "Indicates if the logged values should be sorted according to the specified dimension.", SORTING_TYPES, 0));
        ParameterTypeSingle type = new ParameterTypeString(PARAMETER_SORTING_DIMENSION, "If the sorting type is set to top-k or bottom-k, this dimension is used for sorting.", true);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SORTING_TYPE, true, 1, 2));
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_SORTING_K, "If the sorting type is set to top-k or bottom-k, this number of results will be kept.", 1, Integer.MAX_VALUE, 100);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SORTING_TYPE, false, 1, 2));
        types.add(type);
        return types;
    }
}

