/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChurnReductionExampleSetGenerator
extends AbstractExampleSource {
    public static final String PARAMETER_NUMBER_EXAMPLES = "number_examples";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    private static String[] POSSIBLE_VALUES = new String[]{"New Credit", "Nothing", "End Credit", "Collect Information", "Additional Credit"};

    public ChurnReductionExampleSetGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        int numberOfExamples = this.getParameterAsInt(PARAMETER_NUMBER_EXAMPLES);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        int m = 0;
        while (m < 5) {
            Attribute current = AttributeFactory.createAttribute("Year " + (m + 1), 1);
            int v = 0;
            while (v < POSSIBLE_VALUES.length) {
                current.getMapping().mapString(POSSIBLE_VALUES[v]);
                ++v;
            }
            attributes.add(current);
            ++m;
        }
        Attribute label = AttributeFactory.createAttribute("label", 1);
        label.getMapping().mapString("ok");
        label.getMapping().mapString("terminate");
        attributes.add(label);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        int n = 0;
        while (n < numberOfExamples) {
            double[] values = new double[6];
            int i = 0;
            while (i < 5) {
                values[i] = random.nextInt(POSSIBLE_VALUES.length);
                ++i;
            }
            values[5] = 0.0;
            if (values[0] == 0.0 && values[1] == 1.0) {
                values[5] = 1.0;
            } else if (values[2] == 4.0 && values[4] == 1.0) {
                values[5] = 1.0;
            } else if (values[4] == 5.0) {
                values[5] = 1.0;
            }
            table.addDataRow(new DoubleArrayDataRow(values));
            ++n;
        }
        return table.createExampleSet(label);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_NUMBER_EXAMPLES, "The number of generated examples.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

