/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.learner.functions.kernel.AbstractMySVMModel;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.examples.SVMExamples;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.Kernel;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.svm.SVMInterface;
import com.rapidminer.operator.learner.functions.kernel.logistic.KLR;

public class MyKLRModel
extends AbstractMySVMModel {
    private static final long serialVersionUID = 8033254475867697195L;

    public MyKLRModel(ExampleSet exampleSet, SVMExamples model, Kernel kernel, int kernelType) {
        super(exampleSet, model, kernel, kernelType);
    }

    public String getModelInfo() {
        return "KLR Model (" + this.getNumberOfSupportVectors() + " support vectors)";
    }

    public SVMInterface createSVM() {
        return new KLR();
    }

    public void setPrediction(Example example, double _prediction) {
        double prediction = _prediction - 0.5;
        Attribute predLabel = example.getAttributes().getPredictedLabel();
        int index = prediction > 0.0 ? predLabel.getMapping().getPositiveIndex() : predLabel.getMapping().getNegativeIndex();
        example.setValue(predLabel, index);
        example.setConfidence(predLabel.getMapping().getPositiveString(), 1.0 / (1.0 + Math.exp(-prediction)));
        example.setConfidence(predLabel.getMapping().getNegativeString(), 1.0 / (1.0 + Math.exp(prediction)));
    }
}

