/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.ModelApplier;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.condition.AllInnerOperatorCondition;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.OperatorService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnivariateLabelSeriesPrediction
extends OperatorChain {
    public static final String PARAMETER_WINDOW_WIDTH = "window_width";
    public static final String PARAMETER_MAX_TRAINING_SET_SIZE = "max_training_set_size";
    public static final String PARAMETER_HORIZON = "horizon";

    public UnivariateLabelSeriesPrediction(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label == null) {
            throw new UserError(this, 105);
        }
        if (label.isNominal()) {
            throw new UserError((Operator)this, 102, "series predictions", label.getName());
        }
        int windowWidth = this.getParameterAsInt(PARAMETER_WINDOW_WIDTH);
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        int i = 0;
        while (i < windowWidth) {
            attributes.add(AttributeFactory.createAttribute("series_" + (i + 1), 4));
            ++i;
        }
        Attribute newLabel = AttributeFactory.createAttribute("label", 4);
        attributes.add(newLabel);
        LinkedList<Attribute> testAttributes = new LinkedList<Attribute>();
        int i2 = 0;
        while (i2 < windowWidth) {
            testAttributes.add(AttributeFactory.createAttribute("series_" + (i2 + 1), 4));
            ++i2;
        }
        ModelApplier modelApplier = null;
        try {
            modelApplier = OperatorService.createOperator(ModelApplier.class);
        }
        catch (OperatorCreationException e) {
            throw new OperatorException("Cannot create model applier: " + e.getMessage());
        }
        int horizon = this.getParameterAsInt(PARAMETER_HORIZON);
        int maxTrainingSetSize = this.getParameterAsInt(PARAMETER_MAX_TRAINING_SET_SIZE);
        double[] predictions = new double[exampleSet.size()];
        int i3 = 0;
        while (i3 < horizon) {
            predictions[i3] = Double.NaN;
            ++i3;
        }
        i3 = horizon;
        while (i3 < 2 * horizon + windowWidth - 1) {
            predictions[i3] = exampleSet.getExample(i3 - horizon).getValue(label);
            ++i3;
        }
        int toPredict = windowWidth + 2 * horizon - 1;
        while (toPredict < exampleSet.size()) {
            double predictedValue;
            int startIndex = Math.max(windowWidth + 2 * horizon - 1, toPredict - maxTrainingSetSize);
            MemoryExampleTable trainingTable = new MemoryExampleTable(attributes);
            int s = startIndex;
            while (s <= toPredict) {
                double[] trainingData = new double[windowWidth + 1];
                int d = 0;
                while (d < windowWidth) {
                    trainingData[d] = exampleSet.getExample(s - 2 * horizon - windowWidth + 1 + d).getValue(label);
                    ++d;
                }
                trainingData[trainingData.length - 1] = exampleSet.getExample(s - horizon).getValue(label);
                trainingTable.addDataRow(new DoubleArrayDataRow(trainingData));
                ++s;
            }
            ExampleSet trainingSet = trainingTable.createExampleSet(newLabel);
            IOContainer innerResult = this.getOperator(0).apply(new IOContainer(trainingSet));
            Model model = innerResult.get(Model.class);
            MemoryExampleTable testTable = new MemoryExampleTable(testAttributes);
            double[] testData = new double[windowWidth + 1];
            int d = 0;
            while (d < windowWidth) {
                testData[d] = exampleSet.getExample(toPredict - horizon - windowWidth + 1 + d).getValue(label);
                ++d;
            }
            testTable.addDataRow(new DoubleArrayDataRow(testData));
            ExampleSet testSet = testTable.createExampleSet();
            IOContainer applyResult = modelApplier.apply(new IOContainer(model, testSet));
            ExampleSet predictionSet = applyResult.get(ExampleSet.class);
            predictions[toPredict] = predictedValue = predictionSet.getExample(0).getPredictedLabel();
            PredictionModel.removePredictedLabel(predictionSet);
            this.checkForStop();
            ++toPredict;
        }
        Attribute predictedLabel = PredictionModel.createPredictedLabel(exampleSet, label);
        Iterator e = exampleSet.iterator();
        int counter = 0;
        while (e.hasNext()) {
            Example example = (Example)e.next();
            double prediction = predictions[counter];
            example.setValue(predictedLabel, prediction);
            ++counter;
        }
        return new IOObject[]{exampleSet};
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new AllInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[]{Model.class});
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_WINDOW_WIDTH, "The number of values used as indicators for predicting the target value.", 1, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeInt(PARAMETER_HORIZON, "The gap size used between training windows and prediction value.", 1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeInt(PARAMETER_MAX_TRAINING_SET_SIZE, "The maximum number of examples (windows) used for training the prediction model.", 1, Integer.MAX_VALUE, 10));
        return types;
    }
}

