/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.operator.performance.MinMaxCriterion;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinMaxWrapper
extends Operator {
    public static final String PARAMETER_MINIMUM_WEIGHT = "minimum_weight";

    public MinMaxWrapper(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        PerformanceVector performanceVector = this.getInput(PerformanceVector.class);
        PerformanceVector result = new PerformanceVector();
        int i = 0;
        while (i < performanceVector.size()) {
            PerformanceCriterion crit = performanceVector.getCriterion(i);
            if (crit instanceof MeasuredPerformance) {
                result.addCriterion(new MinMaxCriterion((MeasuredPerformance)crit, this.getParameterAsDouble(PARAMETER_MINIMUM_WEIGHT)));
            }
            ++i;
        }
        result.setMainCriterionName(performanceVector.getMainCriterion().getName());
        return new IOObject[]{result};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{PerformanceVector.class};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{PerformanceVector.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_MINIMUM_WEIGHT, "Defines the weight for the minimum fitness agains the average fitness", 0.0, 1.0, 1.0);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

