/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.learner.functions.kernel.KernelModel;
import com.rapidminer.operator.learner.functions.kernel.SupportVector;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.MDLCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupportVectorCounter
extends Operator {
    public static final String PARAMETER_OPTIMIZATION_DIRECTION = "optimization_direction";
    private double lastCount = Double.NaN;

    public SupportVectorCounter(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("support_vectors", "The number of the currently used support vectors."){

            public double getDoubleValue() {
                return SupportVectorCounter.this.lastCount;
            }
        });
    }

    private PerformanceVector count(KernelModel model, PerformanceVector performanceCriteria) throws OperatorException {
        if (performanceCriteria == null) {
            performanceCriteria = new PerformanceVector();
        }
        this.lastCount = 0.0;
        int svNumber = model.getNumberOfSupportVectors();
        int i = 0;
        while (i < svNumber) {
            SupportVector sv = model.getSupportVector(i);
            if (Math.abs(sv.getAlpha()) > 0.0) {
                this.lastCount += 1.0;
            }
            ++i;
        }
        EstimatedPerformance svCriterion = new EstimatedPerformance("number_of_support_vectors", this.lastCount, 1, this.getParameterAsInt(PARAMETER_OPTIMIZATION_DIRECTION) == 0);
        performanceCriteria.addCriterion(svCriterion);
        return performanceCriteria;
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        Model model = this.getInput(Model.class);
        if (!(model instanceof KernelModel)) {
            throw new UserError((Operator)this, 122, "'support vector based model (kernel model)'");
        }
        PerformanceVector inputPerformance = null;
        try {
            inputPerformance = this.getInput(PerformanceVector.class);
        }
        catch (MissingIOObjectException missingIOObjectException) {
            // empty catch block
        }
        PerformanceVector performance = this.count((KernelModel)model, inputPerformance);
        return new IOObject[]{performance};
    }

    public InputDescription getInputDescription(Class cls) {
        if (Model.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{Model.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{PerformanceVector.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory(PARAMETER_OPTIMIZATION_DIRECTION, "Indicates if the fitness should be maximal for the maximal or the minimal number of support vectors.", MDLCriterion.DIRECTIONS, 0));
        return types;
    }
}

