/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

import com.rapidminer.tools.Tools;

public class ContingencyTableTools {
    public static double getChiSquaredStatistics(double[][] matrix, boolean useYatesCorrection) {
        int numberOfRows = matrix.length;
        int numberOfColumns = matrix[0].length;
        double[] rowSums = new double[numberOfRows];
        double[] columnSums = new double[numberOfColumns];
        double totalSum = 0.0;
        int row = 0;
        while (row < numberOfRows) {
            int column = 0;
            while (column < numberOfColumns) {
                int n = row;
                rowSums[n] = rowSums[n] + matrix[row][column];
                int n2 = column;
                columnSums[n2] = columnSums[n2] + matrix[row][column];
                totalSum += matrix[row][column];
                ++column;
            }
            ++row;
        }
        int degreesOfFreedom = (numberOfRows - 1) * (numberOfColumns - 1);
        boolean useYates = true;
        if (degreesOfFreedom > 1 || !useYatesCorrection) {
            useYates = false;
        } else if (degreesOfFreedom <= 0) {
            return 0.0;
        }
        double expectedValue = 0.0;
        double chiSquaredValue = 0.0;
        int row2 = 0;
        while (row2 < numberOfRows) {
            if (rowSums[row2] > 0.0) {
                int column = 0;
                while (column < numberOfColumns) {
                    if (columnSums[column] > 0.0) {
                        expectedValue = columnSums[column] * rowSums[row2] / totalSum;
                        chiSquaredValue += ContingencyTableTools.getChiSquaredForEntry(matrix[row2][column], expectedValue, useYates);
                    }
                    ++column;
                }
            }
            ++row2;
        }
        return chiSquaredValue;
    }

    private static double getChiSquaredForEntry(double actualFrequency, double expectedFrequency, boolean useYatesCorrection) {
        if (expectedFrequency <= 0.0) {
            return 0.0;
        }
        double difference = Math.abs(actualFrequency - expectedFrequency);
        if (useYatesCorrection && (difference -= 0.5) < 0.0) {
            difference = 0.0;
        }
        return difference * difference / expectedFrequency;
    }

    public static double[][] deleteEmpty(double[][] matrix) {
        int numberOfRows = matrix.length;
        int numberOfColumns = matrix[0].length;
        double[] rowSums = new double[numberOfRows];
        double[] columnSums = new double[numberOfColumns];
        int row = 0;
        while (row < numberOfRows) {
            int column = 0;
            while (column < numberOfColumns) {
                int n = row;
                rowSums[n] = rowSums[n] + matrix[row][column];
                int n2 = column;
                columnSums[n2] = columnSums[n2] + matrix[row][column];
                ++column;
            }
            ++row;
        }
        int nonZeroRowCounter = 0;
        int row2 = 0;
        while (row2 < numberOfRows) {
            if (rowSums[row2] > 0.0) {
                ++nonZeroRowCounter;
            }
            ++row2;
        }
        int nonZeroColumnCounter = 0;
        int column = 0;
        while (column < numberOfColumns) {
            if (columnSums[column] > 0.0) {
                ++nonZeroColumnCounter;
            }
            ++column;
        }
        double[][] result = new double[nonZeroRowCounter][nonZeroColumnCounter];
        int rowIndex = 0;
        int row3 = 0;
        while (row3 < numberOfRows) {
            if (rowSums[row3] > 0.0) {
                int columnIndex = 0;
                int column2 = 0;
                while (column2 < numberOfColumns) {
                    if (columnSums[column2] > 0.0) {
                        result[rowIndex][columnIndex] = matrix[row3][column2];
                        ++columnIndex;
                    }
                    ++column2;
                }
                ++rowIndex;
            }
            ++row3;
        }
        return result;
    }

    public static double symmetricalUncertainty(double[][] matrix) {
        double columnSum = 0.0;
        double columnEntropy = 0.0;
        double totalSum = 0.0;
        int i = 0;
        while (i < matrix[0].length) {
            columnSum = 0.0;
            int j = 0;
            while (j < matrix.length) {
                columnSum += matrix[j][i];
                ++j;
            }
            columnEntropy += ContingencyTableTools.entropy(columnSum);
            totalSum += columnSum;
            ++i;
        }
        columnEntropy -= ContingencyTableTools.entropy(totalSum);
        double rowSum = 0.0;
        double rowEntropy = 0.0;
        double entropyForRows = 0.0;
        int i2 = 0;
        while (i2 < matrix.length) {
            rowSum = 0.0;
            int j = 0;
            while (j < matrix[0].length) {
                rowSum += matrix[i2][j];
                entropyForRows += ContingencyTableTools.entropy(matrix[i2][j]);
                ++j;
            }
            rowEntropy += ContingencyTableTools.entropy(rowSum);
            ++i2;
        }
        entropyForRows -= rowEntropy;
        double informationGain = columnEntropy - entropyForRows;
        if (Tools.isEqual(columnEntropy, 0.0) || Tools.isEqual(rowEntropy -= ContingencyTableTools.entropy(totalSum), 0.0)) {
            return 0.0;
        }
        return 2.0 * (informationGain / (columnEntropy + rowEntropy));
    }

    private static double entropy(double value) {
        if (Tools.isZero(value)) {
            return 0.0;
        }
        return value * Math.log(value);
    }
}

