/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.container;

import com.rapidminer.tools.container.Tupel;
import com.rapidminer.tools.math.container.BoundedPriorityQueue;
import com.rapidminer.tools.math.container.GeometricDataCollection;
import com.rapidminer.tools.math.container.KDTreeNode;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KDTree<T extends Serializable>
implements GeometricDataCollection<T> {
    private static final long serialVersionUID = -8531805333989991725L;
    private KDTreeNode<T> root;
    private int k;
    private DistanceMeasure distance;
    private int size = 0;
    private ArrayList<T> values = new ArrayList();

    public KDTree(int numberOfDimensions, DistanceMeasure distance) {
        this.k = numberOfDimensions;
        this.distance = distance;
    }

    @Override
    public void add(double[] values, T storeValue) {
        ++this.size;
        this.values.add(storeValue);
        if (this.root == null) {
            this.root = new KDTreeNode<T>(values, storeValue, 0);
        } else {
            int currentDimension = 0;
            int depth = 0;
            KDTreeNode<T> currentNode = this.root;
            KDTreeNode<T> childNode = null;
            while ((childNode = currentNode.getNearChild(values)) != null) {
                currentNode = childNode;
                currentDimension = ++depth % this.k;
            }
            currentNode.setChild(new KDTreeNode<T>(values, storeValue, currentDimension));
        }
    }

    @Override
    public Collection<T> getNearestValues(int k, double[] values) {
        BoundedPriorityQueue<Tupel<Double, KDTreeNode<T>>> priorityQueue = this.getNearestNodes(k, values);
        LinkedList<Serializable> neighboursList = new LinkedList<Serializable>();
        for (Tupel tupel : priorityQueue) {
            neighboursList.add((Serializable)((KDTreeNode)tupel.getSecond()).getStoreValue());
        }
        return neighboursList;
    }

    @Override
    public Collection<Tupel<Double, T>> getNearestValueDistances(int k, double[] values) {
        BoundedPriorityQueue<Tupel<Double, KDTreeNode<T>>> priorityQueue = this.getNearestNodes(k, values);
        LinkedList<Tupel<Double, T>> neighboursList = new LinkedList<Tupel<Double, T>>();
        for (Tupel tupel : priorityQueue) {
            neighboursList.add(new Tupel<Double, Serializable>((Double)tupel.getFirst(), (Serializable)((KDTreeNode)tupel.getSecond()).getStoreValue()));
        }
        return neighboursList;
    }

    private BoundedPriorityQueue<Tupel<Double, KDTreeNode<T>>> getNearestNodes(int k, double[] values) {
        Stack<KDTreeNode<T>> nodeStack = new Stack<KDTreeNode<T>>();
        nodeStack = this.traverseTree(nodeStack, this.root, values);
        BoundedPriorityQueue<Tupel<Double, KDTreeNode<T>>> priorityQueue = new BoundedPriorityQueue<Tupel<Double, KDTreeNode<T>>>(k);
        while (!nodeStack.isEmpty()) {
            KDTreeNode<T> currentNode = nodeStack.pop();
            Tupel<Double, KDTreeNode<T>> currentTupel = new Tupel<Double, KDTreeNode<T>>(this.distance.calculateDistance(currentNode.getValues(), values), currentNode);
            priorityQueue.add(currentTupel);
            if (priorityQueue.isFilled() && !((Double)((Tupel)priorityQueue.peek()).getFirst() > currentNode.getCompareValue() - values[currentNode.getCompareDimension()]) || !currentNode.hasFarChild(values)) continue;
            this.traverseTree(nodeStack, currentNode.getFarChild(values), values);
        }
        return priorityQueue;
    }

    private Stack<KDTreeNode<T>> traverseTree(Stack<KDTreeNode<T>> stack, KDTreeNode<T> root, double[] values) {
        KDTreeNode<T> currentNode = root;
        stack.push(currentNode);
        while (currentNode.hasNearChild(values)) {
            currentNode = currentNode.getNearChild(values);
            stack.push(currentNode);
        }
        return stack;
    }

    @Override
    public Collection<Tupel<Double, T>> getNearestValueDistances(double withinDistance, double[] values) {
        throw new RuntimeException("Not supported method");
    }

    @Override
    public Collection<Tupel<Double, T>> getNearestValueDistances(double withinDistance, int butAtLeastK, double[] values) {
        throw new RuntimeException("Not supported method");
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public T get(int index) {
        return (T)((Serializable)this.values.get(index));
    }

    @Override
    public Iterator<T> iterator() {
        return this.values.iterator();
    }
}

