/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.optimization.ec.es;

import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.gui.plotter.SimplePlotterDialog;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.optimization.ec.es.Population;
import com.rapidminer.tools.math.optimization.ec.es.PopulationOperator;

public class PopulationPlotter
implements PopulationOperator {
    private SimplePlotterDialog plotter = null;
    private SimpleDataTable criteriaDataTable = null;

    public void operate(Population pop) {
        if (pop.getNumberOfIndividuals() == 0) {
            return;
        }
        if (this.criteriaDataTable == null) {
            this.criteriaDataTable = this.createDataTable(pop);
        }
        int numberOfCriteria = this.fillDataTable(this.criteriaDataTable, pop);
        if (this.plotter == null) {
            this.plotter = new SimplePlotterDialog(null, this.criteriaDataTable, -1, -1, true, false);
            this.plotter.setCreateOtherPlottersEnabled(false);
            if (numberOfCriteria == 1) {
                this.plotter.setXAxis(0);
                this.plotter.plotColumn(0, true);
            } else if (numberOfCriteria == 2) {
                this.plotter.setXAxis(0);
                this.plotter.plotColumn(1, true);
            } else if (numberOfCriteria > 2) {
                this.plotter.setXAxis(0);
                this.plotter.setYAxis(1);
                this.plotter.plotColumn(2, true);
            }
            this.plotter.setPointType(2);
            this.plotter.setVisible(true);
        }
    }

    public SimpleDataTable createDataTable(Population pop) {
        double[] prototype = pop.get(0).getFitnessValues();
        String[] names = new String[prototype.length];
        int i = 0;
        while (i < names.length) {
            names[i] = "criterion" + i;
            ++i;
        }
        SimpleDataTable dataTable = new SimpleDataTable("Population", names);
        return dataTable;
    }

    public int fillDataTable(SimpleDataTable dataTable, Population pop) {
        dataTable.clear();
        int numberOfCriteria = 0;
        int i = 0;
        while (i < pop.getNumberOfIndividuals()) {
            StringBuffer id = new StringBuffer(String.valueOf(i) + " (");
            double[] currentFitness = pop.get(i).getFitnessValues();
            numberOfCriteria = Math.max(numberOfCriteria, currentFitness.length);
            double[] data = new double[currentFitness.length];
            int d = 0;
            while (d < data.length) {
                data[d] = currentFitness[d];
                if (d != 0) {
                    id.append(", ");
                }
                id.append(Tools.formatNumber(data[d]));
                ++d;
            }
            id.append(")");
            dataTable.add(new SimpleDataTableRow(data, id.toString()));
            ++i;
        }
        return numberOfCriteria;
    }

    public void setCreateOtherPlottersEnabled(boolean enabled) {
        this.plotter.setCreateOtherPlottersEnabled(enabled);
    }
}

