/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.similarity.nominal;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.math.similarity.SimilarityMeasure;

public abstract class AbstractNominalSimilarity
extends SimilarityMeasure {
    private static final long serialVersionUID = 3932502337712338892L;
    private boolean[] binominal;
    private double[] falseIndex;

    public double calculateDistance(double[] value1, double[] value2) {
        return -this.calculateSimilarity(value1, value2);
    }

    public double calculateSimilarity(double[] value1, double[] value2) {
        int equalNonFalseValues = 0;
        int unequalValues = 0;
        int falseValues = 0;
        int i = 0;
        while (i < value1.length) {
            if (value1[i] == value2[i]) {
                if (this.binominal[i]) {
                    if (value1[i] == this.falseIndex[i]) {
                        ++falseValues;
                    } else {
                        ++equalNonFalseValues;
                    }
                } else {
                    ++equalNonFalseValues;
                }
            } else {
                ++unequalValues;
            }
            ++i;
        }
        return this.calculateSimilarity(equalNonFalseValues, unequalValues, falseValues);
    }

    protected abstract double calculateSimilarity(double var1, double var3, double var5);

    public void init(ExampleSet exampleSet) throws OperatorException {
        Tools.onlyNominalAttributes(exampleSet, "nominal similarities");
        this.binominal = new boolean[exampleSet.getAttributes().size()];
        this.falseIndex = new double[exampleSet.getAttributes().size()];
        int index = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            this.binominal[index] = attribute.isNominal() && attribute.getMapping().size() == 2;
            this.falseIndex[index] = this.binominal[index] ? (double)attribute.getMapping().getNegativeIndex() : Double.NaN;
            ++index;
        }
    }
}

