/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.similarity.numerical;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.math.similarity.DistanceMeasure;

public class ChebychevNumericalDistance
extends DistanceMeasure {
    private static final long serialVersionUID = -2995153254013795660L;

    public double calculateDistance(double[] value1, double[] value2) {
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < value1.length) {
            double d;
            double v1 = value1[i];
            double v2 = value2[i];
            if (!Double.isNaN(v1) && !Double.isNaN(v2) && (d = Math.abs(v1 - v2)) > max) {
                max = d;
            }
            ++i;
        }
        if (max > Double.NEGATIVE_INFINITY) {
            return max;
        }
        return Double.NaN;
    }

    public double calculateSimilarity(double[] value1, double[] value2) {
        return -this.calculateDistance(value1, value2);
    }

    public void init(ExampleSet exampleSet) throws OperatorException {
        Tools.onlyNumericalAttributes(exampleSet, "value based similarities");
    }
}

