/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.table.AbstractSparseArrayDataRow;

public class LongSparseArrayDataRow
extends AbstractSparseArrayDataRow {
    private static final long serialVersionUID = 7128381338958693751L;
    private long[] values;

    public LongSparseArrayDataRow() {
        this(0);
    }

    public LongSparseArrayDataRow(int size) {
        super(size);
        this.values = new long[size];
    }

    protected void swapValues(int a, int b) {
        long tt = this.values[a];
        this.values[a] = this.values[b];
        this.values[b] = tt;
    }

    public void resizeValues(int length) {
        long[] d = new long[length];
        System.arraycopy(this.values, 0, d, 0, Math.min(this.values.length, length));
        this.values = d;
    }

    public void removeValue(int index) {
        System.arraycopy(this.values, index + 1, this.values, index, this.values.length - (index + 1));
    }

    public double getValue(int index) {
        return this.values[index];
    }

    public void setValue(int index, double v) {
        this.values[index] = (short)v;
    }

    protected double[] getAllValues() {
        double[] result = new double[this.values.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.values[i];
            ++i;
        }
        return result;
    }
}

